/*
 * Decompiled with CFR 0.152.
 */
package de.renew.shadow;

import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.ShadowTransition;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class ContextLookup {
    private Hashtable<Object, Serializable> map = new Hashtable();

    public ContextLookup(ShadowLookup shadowLookup) {
        Enumeration<ShadowPlace> places = shadowLookup.allPlaces();
        while (places.hasMoreElements()) {
            ShadowPlace shadowPlace = places.nextElement();
            Place place = shadowLookup.get(shadowPlace);
            this.map.put(shadowPlace.context, place);
        }
        Enumeration<ShadowTransition> transitions = shadowLookup.allTransitions();
        while (transitions.hasMoreElements()) {
            ShadowTransition shadowTransition = transitions.nextElement();
            Transition transition = shadowLookup.get(shadowTransition);
            this.map.put(shadowTransition.context, transition);
        }
    }

    public Place getPlace(Object context) {
        return (Place)this.map.get(context);
    }

    public Transition getTransition(Object context) {
        return (Transition)this.map.get(context);
    }

    public Hashtable<Object, Serializable> getMap() {
        return this.map;
    }
}

