/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.arc;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.Inhibiting;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.net.PlaceInstance;
import de.renew.net.SimulatablePlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.unify.Impossible;

class InhibitorExecutable
implements EarlyExecutable {
    SimulatablePlaceInstance pInstance;
    TransitionInstance tInstance;
    Object token;
    boolean trace;

    InhibitorExecutable(SimulatablePlaceInstance placeInstance, TransitionInstance tInstance, Object token, boolean trace) {
        this.pInstance = placeInstance;
        this.tInstance = tInstance;
        this.token = token;
        this.trace = trace;
    }

    public long lockPriority() {
        return this.pInstance.lockOrder;
    }

    @Override
    public int phase() {
        return -4;
    }

    public void lock() {
        this.pInstance.lock.lock();
    }

    @Override
    public void verify(StepIdentifier stepIdentifier) throws Impossible {
        if (this.pInstance.containsTestableToken(this.token)) {
            throw new Impossible();
        }
    }

    @Override
    public void execute(StepIdentifier stepIdentifier) {
        if (this.trace) {
            SimulatorEventLogger.log(stepIdentifier, (SimulationEvent)new Inhibiting(this.token, this.pInstance), (PlaceInstance)this.pInstance);
        }
    }

    @Override
    public void rollback() {
    }

    public void unlock() {
        this.pInstance.lock.unlock();
    }
}

