/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import de.renew.engine.common.CompositeOccurrence;
import de.renew.engine.common.TraceExecutable;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableMapper;
import de.renew.net.FiringCompleteExecutable;
import de.renew.net.FiringStartExecutable;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.TransitionInstance;
import de.renew.net.TransitionOccurrenceDescription;
import de.renew.net.event.FiringEvent;
import de.renew.unify.Impossible;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import java.util.ArrayList;
import java.util.Collection;

public class TransitionOccurrence
extends CompositeOccurrence {
    private VariableMapper mapper = new VariableMapper();

    public TransitionOccurrence(TransitionInstance transitionInstance, Variable params, Searcher searcher) throws Impossible {
        super(transitionInstance);
        Variable thisVariable = this.mapper.map(new LocalVariable("this", false));
        try {
            Unify.unify(thisVariable, transitionInstance.getNetInstance(), null);
        }
        catch (Impossible e) {
            throw new RuntimeException("Unification failed unexpectedly.");
        }
        Transition transition = transitionInstance.getTransition();
        if (transition.uplink != null) {
            Object up = transition.uplink.params.startEvaluation(this.mapper, searcher.recorder, searcher.calcChecker);
            Unify.unify(up, params, searcher.recorder);
        }
        for (TransitionInscription inscription : transition.inscriptions) {
            this.addOccurrences(inscription.makeOccurrences(this.mapper, transitionInstance.getNetInstance(), searcher));
        }
    }

    @Override
    public Collection<Executable> makeExecutables(VariableMapperCopier copier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        ArrayList<Executable> executables = new ArrayList<Executable>();
        executables.addAll(super.makeExecutables(copier));
        if (this.getTransition().getTransition().getTrace()) {
            executables.add(new TraceExecutable("Firing " + String.valueOf(this.getTransition()), this.getTransition()));
        }
        FiringEvent event = new FiringEvent(this.getTransition(), copier.makeCopy(this.mapper));
        executables.add(new FiringStartExecutable(event));
        executables.add(new FiringCompleteExecutable(event));
        return executables;
    }

    @Override
    public OccurrenceDescription makeOccurrenceDescription(VariableMapperCopier copier) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return new TransitionOccurrenceDescription(this.getTransition(), copier.makeCopy(this.mapper));
    }

    public String toString() {
        return this.getTransition().toString();
    }
}

