/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.database.TransactionSource;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ExecuteFinder;
import de.renew.engine.simulator.OverallEarliestTimeFinder;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.engine.simulator.SimulatorEventQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SequentialSimulator
implements Simulator,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(SequentialSimulator.class);
    private static long _runCounter = 0L;
    private final long _simulationRunId;
    private long _cycle = 0L;
    private ExecuteFinder _finder;
    private final Searcher _searcher = new Searcher();
    private boolean _stepFired = false;
    private boolean _isAlive = false;
    private boolean _wantBreak = false;
    private SequentialSimulator _runThread = null;
    private final boolean _wantEventQueueDelay;

    public SequentialSimulator() {
        this(true);
    }

    public SequentialSimulator(boolean wantEventQueueDelay) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._wantEventQueueDelay = wantEventQueueDelay;
        this._simulationRunId = ((long)this.getClass().getName().hashCode() << 32) + _runCounter++;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this.getClass().getSimpleName() + ": Starting run with id " + this._simulationRunId));
        }
        this.findNewBinding();
    }

    @Override
    public boolean isActive() {
        return this._isAlive;
    }

    @Override
    public synchronized void startRun() {
        if (this._runThread != null) {
            return;
        }
        this._runThread = this;
        SimulationThreadPool.getCurrent().execute(this);
        try {
            TransactionSource.simulationStateChanged(true, true);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized void stopRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            while (this._runThread != null) {
                this._wantBreak = true;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                TransactionSource.simulationStateChanged(true, false);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    public synchronized void terminateRun() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            this.stopRun();
            try {
                TransactionSource.simulationStateChanged(false, false);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        });
    }

    private void fire() {
        this._stepFired = false;
        while (this._isAlive && !this._stepFired) {
            if (this._wantEventQueueDelay) {
                SimulatorEventQueue.awaitEmptyQueue();
            }
            this._stepFired = this._finder.execute(this.nextStepIdentifier(), false);
            this.findNewBinding();
        }
    }

    private void findNewBinding() {
        this._finder = new ExecuteFinder();
        while (!this._finder.isCompleted() && !SearchQueue.isTotallyEmpty()) {
            Searchable searchable = SearchQueue.extract();
            OverallEarliestTimeFinder timeFinder = new OverallEarliestTimeFinder(this._finder);
            this._searcher.searchAndRecover(timeFinder, searchable, searchable);
            timeFinder.insertIntoSearchQueue(searchable);
        }
        this._isAlive = this._finder.isCompleted();
    }

    @Override
    public synchronized int step() {
        Future<Integer> future = SimulationThreadPool.getCurrent().submitAndWait(() -> {
            if (this._runThread != null) {
                this.stopRun();
                if (this._isAlive && !this._stepFired) {
                    this.fire();
                }
            } else {
                this.fire();
            }
            if (this._stepFired) {
                return this._isAlive ? 1 : 2;
            }
            return 4;
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (!this._isAlive) {
            this.findNewBinding();
        }
        while (this._isAlive && !this._wantBreak) {
            Thread.yield();
            this.fire();
        }
        SequentialSimulator sequentialSimulator = this;
        synchronized (sequentialSimulator) {
            this._runThread = null;
            this._wantBreak = false;
            this.notifyAll();
        }
    }

    @Override
    public synchronized void refresh() {
        SimulationThreadPool.getCurrent().executeAndWait(() -> {
            if (this._runThread == null) {
                this.findNewBinding();
            }
        });
    }

    @Override
    public boolean isSequential() {
        return true;
    }

    @Override
    public StepIdentifier nextStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(() -> new StepIdentifier(this._simulationRunId, new long[]{++this._cycle}));
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public StepIdentifier currentStepIdentifier() {
        Future<StepIdentifier> future = SimulationThreadPool.getCurrent().submitAndWait(() -> new StepIdentifier(this._simulationRunId, new long[]{this._cycle}));
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public long[] collectSimulationRunIds() {
        return new long[]{this._simulationRunId};
    }
}

