/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searchqueue;

import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searchqueue.RandomQueueFactory;
import de.renew.engine.searchqueue.SearchQueueData;
import de.renew.engine.searchqueue.SearchQueueFactory;
import de.renew.engine.searchqueue.SearchQueueListener;
import de.renew.engine.searchqueue.TimeListener;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SearchQueue {
    public static final Logger logger = Logger.getLogger(SearchQueue.class);
    private static double time = 0.0;
    private static SortedMap<Double, SearchQueueData> queueByTime = new TreeMap<Double, SearchQueueData>();
    private static Hashtable<Searchable, SearchQueueData> queueBySearchable = new Hashtable();
    private static SearchQueueFactory factory = new RandomQueueFactory();
    private static final List<SearchQueueListener> listeners = new ArrayList<SearchQueueListener>();
    private static final List<TimeListener> timeListeners = new ArrayList<TimeListener>();

    private SearchQueue() {
    }

    public static synchronized void setQueueFactory(SearchQueueFactory fac) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        factory = fac;
        queueBySearchable = new Hashtable();
        for (Double key : queueByTime.keySet()) {
            SearchQueueData oldQueue = (SearchQueueData)queueByTime.get(key);
            SearchQueueData newQueue = factory.makeQueue(oldQueue.getTime());
            Enumeration<Searchable> enumeration = oldQueue.elements();
            while (enumeration.hasMoreElements()) {
                Searchable searchable = enumeration.nextElement();
                newQueue.include(searchable);
                queueBySearchable.put(searchable, newQueue);
            }
            queueByTime.put(key, newQueue);
        }
    }

    private static void setTime(double newTime) {
        time = newTime;
        SearchQueue.notifyTimeListeners();
    }

    public static synchronized void reset(double startTime) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation threadbut instead: " + String.valueOf(Thread.currentThread().getThreadGroup());
        queueByTime = new TreeMap<Double, SearchQueueData>();
        queueBySearchable = new Hashtable();
        SimulatorEventLogger.log("Setting time to " + startTime);
        SearchQueue.setTime(startTime);
    }

    public static synchronized double getTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return time;
    }

    private static void advanceTime(double newTime) {
        if (newTime > time) {
            logger.info((Object)("Advancing time to " + newTime));
            SearchQueue.setTime(newTime);
        }
    }

    private static SearchQueueData takeEarliestQueue() {
        if (queueByTime.isEmpty()) {
            return null;
        }
        Double firstKey = queueByTime.firstKey();
        return (SearchQueueData)queueByTime.remove(firstKey);
    }

    public static synchronized void advanceTime() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueueData queue = SearchQueue.takeEarliestQueue();
        if (queue != null) {
            SearchQueue.advanceTime(queue.getTime());
            queueByTime.put(queue.getTime(), queue);
        }
    }

    public static synchronized boolean isCurrentlyEmpty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return !queueByTime.containsKey(time);
    }

    public static synchronized boolean isTotallyEmpty() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        return queueByTime.isEmpty();
    }

    public static synchronized void insertListener(SearchQueueListener listener) {
        listeners.add(listener);
    }

    public static synchronized void insertTimeListener(TimeListener listener) {
        timeListeners.add(listener);
    }

    public static synchronized void removeTimeListener(TimeListener listener) {
        timeListeners.remove(listener);
    }

    private static void notifyListeners() {
        listeners.forEach(SearchQueueListener::searchQueueNonempty);
        listeners.clear();
    }

    private static void notifyTimeListeners() {
        ArrayList<TimeListener> temp = new ArrayList<TimeListener>(timeListeners);
        temp.forEach(TimeListener::timeAdvanced);
    }

    public static synchronized void includeNow(Searchable searchable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueue.include(searchable, time);
    }

    public static synchronized void include(Searchable searchable, double targetTime) {
        SearchQueueData queue;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (targetTime < time) {
            targetTime = time;
        }
        if (targetTime == time) {
            searchable.triggers().clear();
        }
        if ((queue = queueBySearchable.get(searchable)) != null && targetTime < queue.getTime()) {
            queue.exclude(searchable);
            queueBySearchable.remove(searchable);
            if (queue.size() == 0) {
                queueByTime.remove(queue.getTime());
            }
            queue = null;
        }
        if (queue == null) {
            Double key = targetTime;
            if (queueByTime.containsKey(key)) {
                queue = (SearchQueueData)queueByTime.get(key);
            } else {
                queue = factory.makeQueue(targetTime);
                queueByTime.put(key, queue);
            }
            queue.include(searchable);
            queueBySearchable.put(searchable, queue);
        }
        SearchQueue.notifyListeners();
    }

    public static synchronized Searchable extract() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        SearchQueueData queue = SearchQueue.takeEarliestQueue();
        if (queue == null) {
            return null;
        }
        SearchQueue.advanceTime(queue.getTime());
        Searchable searchable = queue.extract();
        queueBySearchable.remove(searchable);
        if (queue.size() > 0) {
            queueByTime.put(queue.getTime(), queue);
        }
        return searchable;
    }

    public static synchronized void saveQueue(ObjectOutput output) throws IOException {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        RenewObjectOutputStream rOut = null;
        if (output instanceof RenewObjectOutputStream) {
            rOut = (RenewObjectOutputStream)output;
        }
        if (rOut != null) {
            rOut.beginDomain(SearchQueue.class);
        }
        output.writeInt(queueByTime.size());
        for (Double key : queueByTime.keySet()) {
            output.writeDouble(key);
            SearchQueueData data = (SearchQueueData)queueByTime.get(key);
            output.writeInt(data.size());
            Enumeration<Searchable> elements = data.elements();
            while (elements.hasMoreElements()) {
                output.writeObject(elements.nextElement());
            }
        }
        if (rOut != null) {
            rOut.writeDelayedObjects();
        }
        if (rOut != null) {
            rOut.endDomain(SearchQueue.class);
        }
    }

    public static synchronized void loadQueue(ObjectInput input) throws IOException, ClassNotFoundException {
        int i;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        Vector<Object> allEntries = new Vector<Object>();
        Vector<Double> allTimes = new Vector<Double>();
        int count = input.readInt();
        try {
            for (i = 0; i < count; ++i) {
                Double time = input.readDouble();
                int size = input.readInt();
                for (int j = 0; j < size; ++j) {
                    allEntries.addElement(input.readObject());
                    allTimes.addElement(time);
                }
            }
        }
        catch (ClassCastException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
            throw new StreamCorruptedException("Object other than Searchable found when looking for SearchQueue elements: " + e.getMessage());
        }
        if (input instanceof RenewObjectInputStream) {
            ((RenewObjectInputStream)input).readDelayedObjects();
        }
        for (i = 0; i < allEntries.size(); ++i) {
            SearchQueue.include((Searchable)allEntries.elementAt(i), (Double)allTimes.elementAt(i));
        }
    }
}

