/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class EntityGenerator {
    private static void generateEntitySource(String tableName, String tableDef) throws IOException {
        Vector<Attribute> attributes = new Vector<Attribute>();
        Vector<Attribute> primaryKey = new Vector<Attribute>();
        StringTokenizer attributeTokenizer = new StringTokenizer(tableDef, ",");
        while (attributeTokenizer.hasMoreTokens()) {
            String attributeDef = attributeTokenizer.nextToken().trim();
            StringTokenizer defTokenizer = new StringTokenizer(attributeDef, " ");
            String attributeName = "";
            if (defTokenizer.hasMoreTokens()) {
                attributeName = defTokenizer.nextToken().trim();
            }
            String attributeType = "";
            if (defTokenizer.hasMoreTokens()) {
                attributeType = defTokenizer.nextToken().trim();
            }
            if (attributeName.equals("")) continue;
            Attribute attribute = attributeType.startsWith("INT") || attributeType.startsWith("NUMBER") ? new Attribute(attributeName, 1) : (attributeType.startsWith("REAL") || attributeType.startsWith("FLOAT") || attributeType.startsWith("DOUBLE") ? new Attribute(attributeName, 2) : new Attribute(attributeName, 3));
            attributes.addElement(attribute);
            if (!attributeName.equals(tableName + "_ID") && !attributeName.equals(tableName + "ID") && !attributeName.equals("ID")) continue;
            primaryKey.addElement(attribute);
        }
        EntityGenerator.generateEntitySource(tableName, attributes, primaryKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateEntitySource(String tableName, Vector<Attribute> attributes, Vector<Attribute> primaryKey) throws IOException {
        String className = EntityGenerator.sqlStringToJavaString(tableName, true) + "Entity";
        String outFileName = className + ".java";
        System.out.println("Generating " + outFileName + "...");
        try (PrintWriter outStream = null;){
            String attributeClassName;
            Attribute attribute;
            File outFile = new File(outFileName);
            outStream = new PrintWriter(new FileOutputStream(outFile));
            outStream.print("import de.renew.database.entitylayer.*;\nimport java.sql.*;\n\n\n/**\n * The entity class for the table " + tableName + ".\n */\npublic class " + className + " extends Entity\n{\n\t// Table specifications\n\t\n\t/**\n\t * The attributes of the entity.\n\t */\n\tprivate static Attribute[] attributes;\n\t\n\t/**\n\t * The primary key of the entity.\n\t */\n\tprivate static Attribute[] primaryKey;\n\t\n\tstatic\n\t{\n\t\tprimaryKey = new Attribute[]\n\t\t{\n");
            boolean firstAttribute = true;
            Enumeration<Attribute> primaryKeyEnum = primaryKey.elements();
            while (primaryKeyEnum.hasMoreElements()) {
                Attribute attribute2 = primaryKeyEnum.nextElement();
                if (firstAttribute) {
                    firstAttribute = false;
                } else {
                    outStream.print(",\n");
                }
                outStream.print("\t\t\tnew Attribute(\"" + attribute2.getName());
                switch (attribute2.getType()) {
                    case 1: {
                        outStream.print("\", Attribute.TYPE_INT)");
                        break;
                    }
                    case 2: {
                        outStream.print("\", Attribute.TYPE_REAL)");
                        break;
                    }
                    case 3: {
                        outStream.print("\", Attribute.TYPE_CHAR)");
                    }
                }
            }
            outStream.print("\n\t\t};\n\t\n\t\tattributes = new Attribute[]\n\t\t{\n");
            firstAttribute = true;
            Enumeration<Attribute> attributesEnum = attributes.elements();
            while (attributesEnum.hasMoreElements()) {
                attribute = attributesEnum.nextElement();
                if (firstAttribute) {
                    firstAttribute = false;
                } else {
                    outStream.print(",\n");
                }
                outStream.print("\t\t\tnew Attribute(\"" + attribute.getName());
                switch (attribute.getType()) {
                    case 1: {
                        outStream.print("\", Attribute.TYPE_INT)");
                        break;
                    }
                    case 2: {
                        outStream.print("\", Attribute.TYPE_REAL)");
                        break;
                    }
                    case 3: {
                        outStream.print("\", Attribute.TYPE_CHAR)");
                    }
                }
            }
            outStream.print("\n\t\t};\n\t}\n\n\t/**\n\t * Creates the entity.\n\t * @param connection The connection to\n\t * be used for entity operations.\n\t * @param dialect The SQL dialect to\n\t * be used for entity operations.\n\t */\n\tpublic " + className + "(Connection connection, SQLDialect dialect)\n\t{\n\t\tsuper(connection, dialect);\n\t}\n\t\n\t/**\n\t * Returns all attributes of the entity as array.\n\t * @param All attributes as array.\n\t */\n\tpublic Attribute[] getAttributes()\n\t{\n\t\treturn attributes;\n\t}\n\t\n\t/**\n\t * Returns the primary key attributes of the entity.\n\t * @return The primary key attributes.\n\t */\n\tpublic Attribute[] getPrimaryKey()\n\t{\n\t\treturn primaryKey;\n\t}\n\t\n\t/**\n\t * Returns the entity's table name.\n\t * @return The entity's table name.\n\t */\n\tpublic String getTableName()\n\t{\n\t\treturn \"" + tableName + "\";\n\t}\n\t\n\t// Attribute getter methods\n\t");
            firstAttribute = true;
            attributesEnum = attributes.elements();
            while (attributesEnum.hasMoreElements()) {
                attribute = attributesEnum.nextElement();
                attributeClassName = "";
                switch (attribute.getType()) {
                    case 1: {
                        attributeClassName = "Integer";
                        break;
                    }
                    case 2: {
                        attributeClassName = "Double";
                        break;
                    }
                    case 3: {
                        attributeClassName = "String";
                    }
                }
                outStream.println("\n\t/**\n\t * Returns the value of the attribute " + attribute.getName() + ".\n\t * @return The value of the attribute " + attribute.getName() + ".\n\t */\n\tpublic " + attributeClassName + " get" + EntityGenerator.sqlStringToJavaString(attribute.getName(), true) + "()\n\t{\n\t\treturn (" + attributeClassName + ") getValue(\"" + attribute.getName() + "\");\n\t}");
            }
            outStream.print("\n\t// Attribute setter methods\n\t");
            firstAttribute = true;
            attributesEnum = attributes.elements();
            while (attributesEnum.hasMoreElements()) {
                attribute = attributesEnum.nextElement();
                attributeClassName = "";
                switch (attribute.getType()) {
                    case 1: {
                        attributeClassName = "Integer";
                        break;
                    }
                    case 2: {
                        attributeClassName = "Double";
                        break;
                    }
                    case 3: {
                        attributeClassName = "String";
                    }
                }
                outStream.println("\n\t/**\n\t * Sets the value of the attribute " + attribute.getName() + ".\n\t * @param " + EntityGenerator.sqlStringToJavaString(attribute.getName(), false) + " The new value for the attribute.\n\t */\n\tpublic void set" + EntityGenerator.sqlStringToJavaString(attribute.getName(), true) + "(" + attributeClassName + " " + EntityGenerator.sqlStringToJavaString(attribute.getName(), false) + ")\n\t{\n\t\tsetValue(\"" + attribute.getName() + "\", " + EntityGenerator.sqlStringToJavaString(attribute.getName(), false) + ");\n\t}");
            }
            outStream.print("}\n");
        }
    }

    public static void generateEntities(String sql) throws IOException {
        sql = sql.toUpperCase().trim();
        sql = sql.replace('\n', ' ');
        sql = sql.replace('\r', ' ');
        sql = sql.replace('\t', ' ');
        int tableNamePos = sql.indexOf("CREATE TABLE ");
        while (tableNamePos >= 0) {
            int tableNameEndPos = (sql = sql.substring(tableNamePos += "CREATE TABLE ".length()).trim()).indexOf(" ");
            if (tableNameEndPos >= 0) {
                String tableName = sql.substring(0, tableNameEndPos).trim();
                int tableDefPos = (sql = sql.substring(tableNameEndPos).trim()).indexOf("(");
                if (tableDefPos >= 0) {
                    int tableDefEndPos;
                    sql = sql.substring(tableDefPos).trim();
                    int bracketDepth = 1;
                    block5: for (tableDefEndPos = 1; tableDefEndPos < sql.length() && bracketDepth > 0; ++tableDefEndPos) {
                        switch (sql.charAt(tableDefEndPos)) {
                            case '(': {
                                ++bracketDepth;
                                continue block5;
                            }
                            case ')': {
                                --bracketDepth;
                            }
                        }
                    }
                    if (tableDefEndPos < sql.length()) {
                        String tableDef = sql.substring(1, tableDefEndPos - 1).trim();
                        EntityGenerator.generateEntitySource(tableName, tableDef);
                        sql = sql.substring(tableDefEndPos).trim();
                    } else {
                        sql = "";
                    }
                    tableDefPos = sql.indexOf("(");
                }
                tableNameEndPos = sql.indexOf(" ");
            }
            tableNamePos = sql.indexOf("CREATE TABLE ");
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1 || args[0].charAt(0) == '-') {
            System.out.println("EntityGenerator V1.0.\nBuilds entity classes out of create table SQL statements.\nParameters: <SQL script file name>\n");
            System.exit(0);
        }
        File inFile = new File(args[0]);
        FileInputStream inStream = new FileInputStream(inFile);
        byte[] inBytes = new byte[(int)inFile.length()];
        inStream.read(inBytes);
        EntityGenerator.generateEntities(new String(inBytes));
        inStream.close();
        System.out.print("Remember to add a package information to the entity classes.\n");
    }

    private static String sqlStringToJavaString(String sqlString, boolean upperString) {
        StringBuffer javaString = new StringBuffer();
        for (int pos = 0; pos < sqlString.length(); ++pos) {
            char ch = sqlString.charAt(pos);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                javaString.append(upperString ? Character.toUpperCase(ch) : Character.toLowerCase(ch));
            }
            upperString = !(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z');
        }
        return javaString.toString();
    }
}

