/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.IllegalTokenException;
import de.renew.database.NetAction;
import de.renew.database.TokenAction;
import de.renew.database.TransactionStrategy;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.StateEntity;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import de.renew.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DatabaseTransactionStrategy
implements TransactionStrategy {
    public static Logger logger = Logger.getLogger(DatabaseTransactionStrategy.class);
    private Connection connection = null;
    private SQLDialect dialect = null;

    public DatabaseTransactionStrategy(String dbUrl, SQLDialect dialect) throws SQLException {
        this.connection = DriverManager.getConnection(dbUrl);
        this.connection.setAutoCommit(false);
        this.dialect = dialect;
    }

    public DatabaseTransactionStrategy(String dbUrl, String dbUser, String dbPassword, SQLDialect dialect) throws SQLException {
        this.connection = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
        this.connection.setAutoCommit(false);
        this.dialect = dialect;
    }

    private void addTokens(TokenAction[] adds) throws SQLException, IllegalTokenException {
        for (int addNumber = 0; addNumber < adds.length; ++addNumber) {
            TokenAction add = adds[addNumber];
            TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
            try {
                tokenEntity.load(add.getTokenID());
            }
            catch (NoSuchEntityException nsee) {
                Object token = add.getToken();
                try {
                    tokenEntity.setTokenId(Integer.valueOf(add.getTokenID()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalTokenException("The token with id " + add.getTokenID() + ", class " + token.getClass().getName() + " and representation " + token.toString() + " cannot be saved, because the ID is not parsable to an int. Currently, only int IDs are supported for tokens.");
                }
                tokenEntity.setClassName(token.getClass().getName());
                byte[] serialisation = null;
                try {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    new ObjectOutputStream(outStream).writeObject(token);
                    serialisation = outStream.toByteArray();
                }
                catch (Exception e) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    e.printStackTrace(new PrintWriter(stream));
                    throw new IllegalTokenException("The token with id " + add.getTokenID() + ", class " + token.getClass().getName() + " and representation " + token.toString() + " couldn't be serialized, because there was an exception during serialisation: " + e.toString() + "\nOnly serializable tokens can be handled by the DatabaseTransactionStrategy.");
                }
                tokenEntity.setSerialisation(new String(Base64Coder.encode((byte[])serialisation)));
                tokenEntity.save();
            }
            TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this.connection, this.dialect);
            try {
                tokenPositionEntity.load(new Object[]{add.getTokenID(), add.getNetID(), add.getPlaceID().toString()});
                tokenPositionEntity.setQuantity(tokenPositionEntity.getQuantity() + 1);
            }
            catch (NoSuchEntityException nsee) {
                tokenPositionEntity.setTokenId(Integer.valueOf(add.getTokenID()));
                try {
                    tokenPositionEntity.setNetInstanceId(Integer.valueOf(add.getNetID()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalTokenException("The net instance ID " + add.getNetID() + " cannot be saved, because it is not parsable to an int. Currently, only int IDs are supported for net instances.");
                }
                tokenPositionEntity.setPlaceInstanceId(add.getPlaceID().toString());
                tokenPositionEntity.setQuantity(1);
            }
            tokenPositionEntity.save();
        }
    }

    private void createNets(NetAction[] creates) throws SQLException {
        for (int createNumber = 0; createNumber < creates.length; ++createNumber) {
            NetAction create = creates[createNumber];
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
            try {
                netInstanceEntity.load(create.getNetID());
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(DatabaseTransactionStrategy.class.getSimpleName() + ": loaded net instance entity with id " + create.getNetID()));
                continue;
            }
            catch (NoSuchEntityException nsee) {
                try {
                    netInstanceEntity.setNetInstanceId(Integer.valueOf(create.getNetID()));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("The net instance ID " + create.getNetID() + " cannot be saved, because it is not parsable to an int. Currently, only int IDs are supported for net instances.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(DatabaseTransactionStrategy.class.getSimpleName() + ": create net instance entity with name " + create.getName()));
                }
                netInstanceEntity.setName(create.getName());
                netInstanceEntity.setDrawingOpen(0);
                netInstanceEntity.save();
            }
        }
    }

    private void deleteNets(NetAction[] deletes) throws SQLException {
        for (int deleteNumber = 0; deleteNumber < deletes.length; ++deleteNumber) {
            try {
                NetAction delete = deletes[deleteNumber];
                NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
                netInstanceEntity.load(delete.getNetID());
                TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this.connection, this.dialect);
                Vector<Entity> tokenPositionEntities = Entity.getEntities(tokenPositionEntity, "NET_INSTANCE_ID='" + delete.getNetID() + "'");
                Enumeration<Entity> tokenPositionEntitiesEnum = tokenPositionEntities.elements();
                while (tokenPositionEntitiesEnum.hasMoreElements()) {
                    tokenPositionEntity = (TokenPositionEntity)tokenPositionEntitiesEnum.nextElement();
                    String tokenId = String.valueOf(tokenPositionEntity.getTokenId());
                    tokenPositionEntity.delete();
                    if (Entity.getEntities(tokenPositionEntity, "TOKEN_ID='" + tokenId + "'").size() > 0) continue;
                    TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
                    tokenEntity.load(tokenId);
                    tokenEntity.delete();
                }
                netInstanceEntity.delete();
                continue;
            }
            catch (NoSuchEntityException noSuchEntityException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.close();
            this.connection = null;
        }
    }

    @Override
    public void netInstanceDrawingClosed(String netInstanceID) throws SQLException {
        try {
            logger.debug((Object)("Closed " + netInstanceID));
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
            netInstanceEntity.load(netInstanceID);
            netInstanceEntity.setDrawingOpen(0);
            netInstanceEntity.save();
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
    }

    @Override
    public void netInstanceDrawingOpened(String netInstanceID) throws SQLException {
        try {
            logger.debug((Object)("Opened " + netInstanceID));
            NetInstanceEntity netInstanceEntity = new NetInstanceEntity(this.connection, this.dialect);
            netInstanceEntity.load(netInstanceID);
            netInstanceEntity.setDrawingOpen(1);
            netInstanceEntity.save();
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
    }

    @Override
    public void perform(NetAction[] createActions, TokenAction[] addActions, TokenAction[] removeActions, NetAction[] deleteActions) throws SQLException, IllegalTokenException {
        this.createNets(createActions);
        this.addTokens(addActions);
        this.removeTokens(removeActions);
        this.deleteNets(deleteActions);
        this.connection.commit();
    }

    private void removeTokens(TokenAction[] removes) throws SQLException, IllegalTokenException {
        for (int removeNumber = 0; removeNumber < removes.length; ++removeNumber) {
            TokenAction remove = removes[removeNumber];
            Object token = remove.getToken();
            if (!(token instanceof Serializable)) {
                throw new IllegalTokenException("Token " + remove.getTokenID() + " is not serializable.\nOnly serializable tokens can be handled by the DatabaseTransactionStrategy.");
            }
            try {
                TokenEntity tokenEntity = new TokenEntity(this.connection, this.dialect);
                tokenEntity.load(remove.getTokenID());
                TokenPositionEntity tokenPositionEntity = new TokenPositionEntity(this.connection, this.dialect);
                try {
                    tokenPositionEntity.load(new Object[]{remove.getTokenID(), remove.getNetID(), remove.getPlaceID().toString()});
                    if (tokenPositionEntity.getQuantity() <= 1) {
                        tokenPositionEntity.delete();
                    } else {
                        tokenPositionEntity.setQuantity(tokenPositionEntity.getQuantity() - 1);
                        tokenPositionEntity.save();
                    }
                }
                catch (NoSuchEntityException noSuchEntityException) {
                    // empty catch block
                }
                if (Entity.getEntities(tokenPositionEntity, "TOKEN_ID='" + remove.getTokenID() + "'").size() > 0) continue;
                tokenEntity.delete();
                continue;
            }
            catch (NoSuchEntityException noSuchEntityException) {
                // empty catch block
            }
        }
    }

    @Override
    public void simulationStateChanged(boolean inited, boolean running) throws SQLException {
        StateEntity stateEntity = new StateEntity(this.connection, this.dialect);
        try {
            stateEntity.load(new Object[0]);
        }
        catch (NoSuchEntityException noSuchEntityException) {
            // empty catch block
        }
        stateEntity.setInited(inited ? 1 : 0);
        stateEntity.setRunning(running ? 1 : 0);
        stateEntity.save();
        this.connection.commit();
    }
}

