/*
 * Decompiled with CFR 0.152.
 */
package de.renew.windowmanagement.commands;

import bibliothek.gui.dock.support.lookandfeel.LookAndFeelList;
import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Map;
import javax.swing.UIManager;

public class DarkThemeCLCommand
implements CLCommand {
    public void execute(String[] args, PrintStream response) {
        String themeName = "Nimbus";
        UIManager.put("nimbusBase", new Color(0, 15, 33));
        UIManager.put("nimbusFocus", new Color(23, 43, 68));
        UIManager.put("control", new Color(58, 78, 98));
        UIManager.put("text", new Color(145, 158, 175));
        UIManager.put("info", new Color(23, 43, 68));
        UIManager.put("nimbusSelectionBackground", new Color(21, 35, 53));
        UIManager.put("nimbusLightBackground", new Color(23, 43, 68));
        LookAndFeelList list = LookAndFeelList.getDefaultList();
        if ("Nimbus".equals(list.getLookAndFeel().getName())) {
            for (int i = 0; i < list.size(); ++i) {
                LookAndFeelList.Info info = list.get(i);
                if (!"Nimbus".equals(info.getName())) continue;
                list.setLookAndFeel(info);
                break;
            }
        }
        if (args != null && args.length > 0) {
            String after = args[0];
            int length = args.length;
            String[] newArgs = length > 1 ? Arrays.copyOfRange(args, 1, length - 1) : new String[]{};
            Map commands = PluginManager.getInstance().getCLCommands();
            CLCommand clCommand = (CLCommand)commands.get(after);
            if (clCommand != null) {
                clCommand.execute(newArgs, response);
            }
        }
    }

    public String getDescription() {
        return "Change the color theme of the Nimbus look and feel to a dark blue variant.";
    }

    public String getArguments() {
        return null;
    }
}

