/*
 * Decompiled with CFR 0.152.
 */
package de.renew.windowmanagement;

import de.renew.windowmanagement.DragCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class DraggableComponentAdapter
extends MouseAdapter {
    private final DragCanvas _canvas;
    private final Component _dragTarget;
    protected Cursor _draggingCursor = Cursor.getPredefinedCursor(12);

    public DraggableComponentAdapter(DragCanvas canvas, Component target) {
        this._dragTarget = target;
        this._canvas = canvas;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this._dragTarget.isShowing()) {
            Point absolute = e.getLocationOnScreen();
            this._dragTarget.setCursor(this._draggingCursor);
            BufferedImage image = new BufferedImage(this._dragTarget.getWidth(), this._dragTarget.getHeight(), 1);
            Graphics g = image.getGraphics();
            this._dragTarget.printAll(g);
            g.setColor(new Color(0.6f, 0.6f, 0.6f, 0.6f));
            g.fillRect(0, 0, this._dragTarget.getWidth(), this._dragTarget.getHeight());
            this._canvas.requestOverlayingShadow(absolute, image);
            Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
            ((JComponent)e.getSource()).scrollRectToVisible(r);
            this._canvas.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point absolute = e.getLocationOnScreen();
        if (this.wasDragged(absolute)) {
            Point canvasAbsolute = this._canvas.getLocationOnScreen();
            Point adjustedLocation = new Point(absolute.x - canvasAbsolute.x, absolute.y - canvasAbsolute.y);
            if (this._canvas.contains(adjustedLocation)) {
                this._canvas.dropComponent(this._dragTarget, absolute);
            }
        }
        this._canvas.requestOverlayingShadow(null, null);
        this._canvas.repaint();
        this._dragTarget.setCursor(Cursor.getDefaultCursor());
        this._canvas.validate();
    }

    private boolean wasDragged(Point newPosition) {
        Point oldPosition = this._dragTarget.getLocationOnScreen();
        return oldPosition.x + this._dragTarget.getWidth() < newPosition.x || oldPosition.x > newPosition.x || oldPosition.y + this._dragTarget.getHeight() < newPosition.y || oldPosition.y > newPosition.y;
    }
}

