/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.dock.station.stack.tab.AbstractTabLayoutManagerPane;
import bibliothek.gui.dock.station.stack.tab.TabLayoutManager;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTabLayoutManager<I extends AbstractTabLayoutManagerPane>
implements TabLayoutManager {
    private List<I> infos = new ArrayList<I>();

    @Override
    public void install(TabPane pane) {
        I info = this.createInfoFor(pane);
        pane.addTabPaneListener((TabPaneListener)info);
        this.infos.add(info);
    }

    @Override
    public void uninstall(TabPane pane) {
        ListIterator<I> iterator = this.infos.listIterator();
        while (iterator.hasNext()) {
            AbstractTabLayoutManagerPane next = (AbstractTabLayoutManagerPane)iterator.next();
            if (next.getPane() != pane) continue;
            iterator.remove();
            pane.removeTabPaneListener(next);
            this.destroy(next);
            next.uninstalled();
        }
    }

    protected abstract I createInfoFor(TabPane var1);

    protected abstract void destroy(I var1);

    public I getInfo(TabPane pane) {
        for (AbstractTabLayoutManagerPane check : this.infos) {
            if (check.getPane() != pane) continue;
            return (I)check;
        }
        return null;
    }
}

