/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class WizardPage {
    private static final Logger LOGGER = Logger.getLogger(WizardPage.class);
    private String _id;
    private JPanel _panel = new JPanel();

    public WizardPage(String id) {
        this.restoreDefaultLayout();
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public JPanel getPanel() {
        return this._panel;
    }

    void restoreDefaultLayout() {
        this._panel.setLayout(new BoxLayout(this._panel, 3));
    }

    protected boolean isLastPage() {
        return false;
    }

    protected String nextButtonTitle() {
        return null;
    }

    protected Component initialFocusComponent() {
        return null;
    }

    final void internalDidAppear() {
        final Component focusComponent = this.initialFocusComponent();
        if (focusComponent != null) {
            LOGGER.debug((Object)("component requesting focus: " + String.valueOf(focusComponent)));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    focusComponent.requestFocusInWindow();
                }
            });
        }
        this.didAppear();
    }

    protected void didLoad() {
    }

    protected void didAppear() {
    }

    protected void willDisappear() {
    }

    protected abstract void saveState();

    protected abstract void resetState();
}

