/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.search;

import de.renew.refactoring.match.FileMatch;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.search.IteratorSearcher;
import de.renew.refactoring.search.range.FileSearchRange;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.log4j.Logger;

public abstract class LineByLineFileSearcher
extends IteratorSearcher<File, List<FileMatch>> {
    private static final Logger LOGGER = Logger.getLogger(LineByLineFileSearcher.class);

    public LineByLineFileSearcher(FileSearchRange searchRange) {
        super(searchRange.files(), searchRange.numberOfFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<FileMatch> searchItem(File file) {
        LOGGER.debug((Object)("Searching file: " + String.valueOf(file)));
        this.newFile();
        try (Scanner scanner = null;){
            scanner = new Scanner(file);
            ArrayList<FileMatch> result = new ArrayList<FileMatch>();
            int lineNumber = 0;
            while (scanner.hasNext()) {
                ++lineNumber;
                String line = scanner.nextLine();
                for (StringMatch match : this.searchLine(line)) {
                    result.add(new FileMatch(file, lineNumber, match));
                    LOGGER.debug((Object)("Found a match in line " + lineNumber));
                }
            }
            ArrayList<FileMatch> arrayList = result;
            return arrayList;
        }
        return null;
    }

    @Override
    public String getCurrentItemString() {
        return ((File)this.getCurrentItem()).getName();
    }

    protected abstract List<StringMatch> searchLine(String var1);

    protected void newFile() {
    }
}

