/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse.name;

import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.name.NameFinder;
import de.renew.refactoring.parse.name.NoNameFinder;
import de.renew.refactoring.parse.name.RegexNameFinder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RegexClassNameFinder
implements NameFinder {
    private static final Logger LOGGER = Logger.getLogger(RegexClassNameFinder.class);
    private final String _className;
    private final String _packageName;
    private final NameFinder _classNameFinder;
    private final NameFinder _qualifiedClassNameFinder;

    public RegexClassNameFinder(String fullyQualifiedClassName, boolean matchClassName) {
        this(RegexClassNameFinder.className(fullyQualifiedClassName), RegexClassNameFinder.packageName(fullyQualifiedClassName), matchClassName);
    }

    public RegexClassNameFinder(String className, String packageName, boolean matchClassName) {
        this._className = className;
        this._packageName = packageName;
        this._classNameFinder = matchClassName ? new RegexNameFinder(className, ".", null) : new NoNameFinder();
        this._qualifiedClassNameFinder = new RegexNameFinder(packageName + "." + className);
    }

    @Override
    public boolean find(String input) {
        return this._classNameFinder.find(input) || this._qualifiedClassNameFinder.find(input);
    }

    @Override
    public List<StringMatch> listOfMatches(String input) {
        ArrayList<StringMatch> result = new ArrayList<StringMatch>(this._classNameFinder.listOfMatches(input));
        for (StringMatch match : this._qualifiedClassNameFinder.listOfMatches(input)) {
            int classNameStart = match.start() + match.match().lastIndexOf(this._className);
            int classNameEnd = classNameStart + this._className.length();
            result.add(new StringMatch(this._className, classNameStart, classNameEnd));
        }
        return result;
    }

    private static String className(String fullyQualifiedClassName) {
        int lastDot = fullyQualifiedClassName.lastIndexOf(46);
        return fullyQualifiedClassName.substring(lastDot + 1);
    }

    private static String packageName(String fullyQualifiedClassName) {
        int lastDot = fullyQualifiedClassName.lastIndexOf(46);
        return fullyQualifiedClassName.substring(0, lastDot);
    }
}

