/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.apache.log4j.Logger;

public class RestrictedEditingFilters {
    private static final Logger LOGGER = Logger.getLogger(RestrictedEditingFilters.class);
    private JTextComponent _textField;
    private final int _startIndex;
    private int _endIndex;
    private RestrictedEditingNavigationFilter _navigationFilter;
    private RestrictedEditingDocumentFilter _documentFilter;

    public RestrictedEditingFilters(JTextComponent textField, int startIndex, int endIndex) {
        this._textField = textField;
        this._startIndex = startIndex;
        this._endIndex = endIndex;
        this._navigationFilter = new RestrictedEditingNavigationFilter();
        this._documentFilter = new RestrictedEditingDocumentFilter();
    }

    public NavigationFilter getNavigationFilter() {
        return this._navigationFilter;
    }

    public DocumentFilter getDocumentFilter() {
        return this._documentFilter;
    }

    public int getStartIndex() {
        return this._startIndex;
    }

    public synchronized int getEndIndex() {
        return this._endIndex;
    }

    private synchronized void moveEndIndex(int n) {
        this._endIndex += n;
    }

    private synchronized boolean positionIsAllowed(int position) {
        return position >= this._startIndex && position <= this._endIndex;
    }

    private synchronized int allowedPositionNear(int position) {
        if (this.positionIsAllowed(position)) {
            return position;
        }
        return position > this._endIndex ? this._endIndex : this._startIndex;
    }

    class RestrictedEditingNavigationFilter
    extends NavigationFilter {
        RestrictedEditingNavigationFilter() {
        }

        @Override
        public void setDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            super.setDot(fb, RestrictedEditingFilters.this.allowedPositionNear(dot), bias);
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass fb, int dot, Position.Bias bias) {
            super.moveDot(fb, RestrictedEditingFilters.this.allowedPositionNear(dot), bias);
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent text, int pos, Position.Bias bias, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int proposed = super.getNextVisualPositionFrom(text, pos, bias, direction, biasRet);
            return RestrictedEditingFilters.this.allowedPositionNear(proposed);
        }
    }

    class RestrictedEditingDocumentFilter
    extends DocumentFilter {
        RestrictedEditingDocumentFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (RestrictedEditingFilters.this.positionIsAllowed(offset) && RestrictedEditingFilters.this.positionIsAllowed(offset + length)) {
                RestrictedEditingFilters.this.moveEndIndex(-length);
                super.remove(fb, offset, length);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (RestrictedEditingFilters.this.positionIsAllowed(offset)) {
                RestrictedEditingFilters.this.moveEndIndex(string.length());
            }
            super.insertString(fb, offset, string, attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (RestrictedEditingFilters.this.positionIsAllowed(offset) && RestrictedEditingFilters.this.positionIsAllowed(offset + length)) {
                RestrictedEditingFilters.this.moveEndIndex(text.length() - length);
            }
            super.replace(fb, offset, length, text, attrs);
        }
    }
}

