/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import de.renew.refactoring.inline.InlineStepWithListener;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class PopupMenuStep<T>
extends InlineStepWithListener {
    private static final Logger LOGGER = Logger.getLogger(PopupMenuStep.class);
    private JPopupMenu _menu;
    private Map<JMenuItem, T> _menuItems = new HashMap<JMenuItem, T>();

    public PopupMenuStep(Container container, Point origin, List<T> entries) {
        this._menu = new JPopupMenu();
        this.addEntries(entries);
        this._menu.addPopupMenuListener(this.popupMenuListener());
        this._menu.show(container, origin.x, origin.y);
    }

    private void addEntries(List<T> entries) {
        for (T entry : entries) {
            JMenuItem item = new JMenuItem(this.titleForEntry(entry));
            ActionListener customListener = this.actionListenerForEntry(entry);
            item.addActionListener(this.makeOuterListener(customListener));
            this._menu.add(item);
            this._menuItems.put(item, entry);
        }
    }

    private ActionListener makeOuterListener(final ActionListener inner) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (inner != null) {
                    inner.actionPerformed(e);
                }
                PopupMenuStep.this.informListenersFinished();
            }
        };
    }

    public T getEntryForMenuItem(JMenuItem item) {
        return this._menuItems.get(item);
    }

    public ActionListener actionListenerForEntry(T entry) {
        return null;
    }

    public String titleForEntry(T entry) {
        return entry.toString();
    }

    private PopupMenuListener popupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                PopupMenuStep.this.informListenersCancelled();
            }
        };
    }
}

