<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# NavigatorGit

## User Guide

_NavigatorGit_ extends the Navigator with Git repository functionality.

### Features

- Display current branch in Renew
- Retrieve the last commit
- Update to reflect changes made to the branch

### Example Usage

1. Open the Navigator via File -> Open Navigator
2. Open the Renew folder by using Add Files
3. The name of the current branch will now be displayed besides the Renew folder (e.g. Renew @ modular-master)

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

_NavigatorGit_ does not provide any commands.

### Installation

Install _NavigatorGit_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `CH`: Used for menu management by Navigator
- `ImageNetDiff`: Used for comparing .png files
- `NavigatorVC`: _NavigatorGit_ extends the functionality of NavigatorVC
- `Gitective`: Provides utilities for dealing with Git blobs
- `Jgit`: Provides repository functionality
- `log4j`: Logging framework

### Configuration

No properties are read during the initialization of _NavigatorGit_.

## Developer Guide

### Core Classes

- `NavigatorGitPlugin`: Implements the `IPlugin` interface to manage the startup and shutdown.
- `GitRepository`: Provides functionality for working with Git repositories.

### How to Extend

_NavigatorGit_ is not meant to be extended.

<!-- ### Additional Information -->

<!-- Common issues, explanations for inconsistencies, etc. -->

<!-- Contribution Info -->

<!-- License -->
