/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.Assert;
import org.gitective.core.GitException;
import org.gitective.core.PathFilterUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommitUtils {
    public static RevCommit getCommit(Repository repository, String revision) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revision"));
        }
        if (revision.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revision"));
        }
        return CommitUtils.parse(repository, CommitUtils.resolve(repository, revision));
    }

    public static RevCommit getCommit(Repository repository, ObjectId commitId) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commitId == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commit id"));
        }
        return CommitUtils.parse(repository, commitId);
    }

    public static RevCommit getHead(Repository repository) {
        return CommitUtils.getCommit(repository, "HEAD");
    }

    public static RevCommit getMaster(Repository repository) {
        return CommitUtils.getCommit(repository, "master");
    }

    public static RevCommit getBase(Repository repository, ObjectId ... commits) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Commits"));
        }
        if (commits.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Commits"));
        }
        return CommitUtils.walkToBase(repository, commits);
    }

    public static RevCommit getBase(Repository repository, String ... revisions) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revisions == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revisions"));
        }
        if (revisions.length == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revisions"));
        }
        int length = revisions.length;
        ObjectId[] commits = new ObjectId[length];
        for (int i = 0; i < length; ++i) {
            commits[i] = CommitUtils.strictResolve(repository, revisions[i]);
        }
        return CommitUtils.walkToBase(repository, commits);
    }

    public static RevCommit getRef(Repository repository, String refName) {
        Ref ref;
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (refName == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Ref name"));
        }
        if (refName.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Ref name"));
        }
        try {
            ref = repository.getRef(refName);
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        return ref != null ? CommitUtils.lookupRef(repository, ref) : null;
    }

    public static RevCommit getRef(Repository repository, Ref ref) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Ref"));
        }
        return CommitUtils.lookupRef(repository, ref);
    }

    public static Collection<RevCommit> getTags(Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        HashSet<RevCommit> commits = new HashSet<RevCommit>();
        RevWalk walk = new RevWalk(repository);
        RefDatabase refDb = repository.getRefDatabase();
        try {
            CommitUtils.getRefCommits(walk, refDb, "refs/tags/", commits);
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        finally {
            walk.release();
        }
        return commits;
    }

    public static Collection<RevCommit> getBranches(Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        HashSet<RevCommit> commits = new HashSet<RevCommit>();
        RevWalk walk = new RevWalk(repository);
        RefDatabase refDb = repository.getRefDatabase();
        try {
            CommitUtils.getRefCommits(walk, refDb, "refs/heads/", commits);
            CommitUtils.getRefCommits(walk, refDb, "refs/remotes/", commits);
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        finally {
            walk.release();
        }
        return commits;
    }

    private static void getRefCommits(RevWalk walk, RefDatabase refDb, String prefix, Collection<RevCommit> commits) throws IOException {
        for (Ref ref : refDb.getRefs(prefix).values()) {
            RevCommit commit = CommitUtils.getRef(walk, ref);
            if (commit == null) continue;
            commits.add(commit);
        }
    }

    private static RevCommit lookupRef(Repository repository, Ref ref) {
        RevWalk walk = new RevWalk(repository);
        try {
            RevCommit revCommit = CommitUtils.getRef(walk, ref);
            return revCommit;
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        finally {
            walk.release();
        }
    }

    private static RevCommit getRef(RevWalk walk, Ref ref) throws IOException {
        ObjectId id = ref.getPeeledObjectId();
        if (id == null) {
            id = ref.getObjectId();
        }
        return id != null ? walk.parseCommit((AnyObjectId)id) : null;
    }

    protected static ObjectId resolve(Repository repository, String revision) {
        try {
            return repository.resolve(revision);
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
    }

    protected static ObjectId strictResolve(Repository repository, String revision) {
        ObjectId resolved = CommitUtils.resolve(repository, revision);
        if (resolved == null) {
            throw new GitException(MessageFormat.format("Revision ''{0}'' could not be resolved", revision), repository);
        }
        return resolved;
    }

    private static RevCommit walkToBase(Repository repository, ObjectId ... commits) {
        RevWalk walk = new RevWalk(repository);
        walk.setRevFilter(RevFilter.MERGE_BASE);
        try {
            for (int i = 0; i < commits.length; ++i) {
                walk.markStart(walk.parseCommit((AnyObjectId)commits[i]));
            }
            RevCommit base = walk.next();
            if (base != null) {
                walk.parseBody((RevObject)base);
            }
            RevCommit revCommit = base;
            return revCommit;
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        finally {
            walk.release();
        }
    }

    protected static RevCommit parse(Repository repository, ObjectId commit) {
        RevWalk walk = new RevWalk(repository);
        walk.setRetainBody(true);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)commit);
            return revCommit;
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        finally {
            walk.release();
        }
    }

    protected static RevCommit parse(Repository repository, ObjectReader reader, ObjectId commit) {
        RevWalk walk = new RevWalk(reader);
        walk.setRetainBody(true);
        try {
            return walk.parseCommit((AnyObjectId)commit);
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
    }

    public static RevCommit getLastCommit(Repository repository, String path) {
        return CommitUtils.getLastCommit(repository, "HEAD", path);
    }

    public static RevCommit getLastCommit(Repository repository, String revision, String path) {
        if (repository == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Repository"));
        }
        if (revision == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Revision"));
        }
        if (revision.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Revision"));
        }
        if (path == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Path"));
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Path"));
        }
        RevWalk walk = new RevWalk(repository);
        walk.setRetainBody(true);
        try {
            walk.markStart(walk.parseCommit((AnyObjectId)CommitUtils.strictResolve(repository, revision)));
            walk.setTreeFilter(PathFilterUtils.and(path));
            RevCommit revCommit = walk.next();
            return revCommit;
        }
        catch (IOException e) {
            throw new GitException(e, repository);
        }
        finally {
            walk.release();
        }
    }
}

