/*
 * Decompiled with CFR 0.152.
 */
package de.renew.minimap.command;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.util.Command;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import de.renew.minimap.component.MiniMapFrame;
import de.renew.plugin.command.CLCommand;
import de.renew.windowmanagement.Workbench;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ShowMiniMapCommand
extends Command
implements CLCommand {
    private static final Logger LOGGER = Logger.getLogger(ShowMiniMapCommand.class);
    public static final String COMMAND_NAME = "Show MiniMap...";
    private DefaultSingleCDockable _frame;
    private JMenuItem _menuItem;
    private Workbench _workbench;

    public ShowMiniMapCommand(Workbench workbench) {
        super(COMMAND_NAME);
        this._workbench = workbench;
    }

    public void execute() {
        this.showMiniMap();
    }

    public void execute(String[] args, final PrintStream response) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    response.println("Show MiniMap.");
                    ShowMiniMapCommand.this.execute();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            response.println("Exception while showing MiniMap: " + String.valueOf(e.getTargetException()));
            LOGGER.error((Object)e.getTargetException().toString(), (Throwable)e);
        }
    }

    public String getArguments() {
        return null;
    }

    public String getDescription() {
        return "Opens a window where commands can be executed.";
    }

    private void addMenuItemToWindowsMenu() {
        if (this._menuItem != null) {
            return;
        }
        this._menuItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowMiniMapCommand.this.bringToFront();
            }
        });
        this._menuItem.setText(COMMAND_NAME);
        MenuManager.getInstance().getWindowsMenu().add(this._menuItem);
    }

    private void bringToFront() {
        this._frame.setVisible(true);
        this._frame.toFront();
    }

    private void closeMiniMapFrame() {
        this.removeMenuItemFromWindowsMenu();
        MiniMapFrame.destroyMiniMapFrame();
    }

    private void removeMenuItemFromWindowsMenu() {
        DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().remove(this._menuItem);
        this._menuItem = null;
    }

    private void showMiniMap() {
        this._frame = MiniMapFrame.getFrame(this._workbench);
        this._frame.setVisible(true);
        this.addMenuItemToWindowsMenu();
    }
}

