/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.LolaTask;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.LolaAnalyzer;
import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.gui.LolaGUI;
import de.renew.lola2.gui.LolaGUIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class TasksPanel
extends JPanel {
    private LolaGUI _lolaGUI;
    private static Logger _logger = Logger.getLogger(TasksPanel.class);
    private JTable _taskTable;
    protected String _newTaskText = "";
    private static final Vector<String> TASK_COLUMN_NAMES = new Vector();

    public TasksPanel(LolaGUI lolaGUI) {
        TASK_COLUMN_NAMES.add("Result");
        TASK_COLUMN_NAMES.add("Verification Task");
        this._lolaGUI = lolaGUI;
        this.setVisible(true);
        this.setup();
    }

    private void setup() {
        this._taskTable = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setupTaskTable();
        JScrollPane scrollPane = new JScrollPane(this._taskTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        final JTextField newTask = new JTextField(20);
        newTask.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TasksPanel.this._newTaskText = newTask.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TasksPanel.this._newTaskText = newTask.getText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        newTask.setToolTipText("<html>Input new verification task here and click the add button.<br>(some pointer on syntax should go here) <br><i>There is no syntax check so far.</i></html> ");
        JButton addButton = new JButton("Add task");
        addButton.setToolTipText("Add the entered task to the list");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TasksPanel.this._newTaskText != "") {
                    _logger.info((Object)("[Lola GUI] Adding Task: " + TasksPanel.this._newTaskText));
                    if (!TasksPanel.this._newTaskText.toLowerCase().startsWith("formula")) {
                        TasksPanel.this._newTaskText = "FORMULA " + TasksPanel.this._newTaskText;
                    }
                    TextFigure tmpFig = new TextFigure(false);
                    tmpFig.setText(TasksPanel.this._newTaskText);
                    TasksPanel.this._lolaGUI._drawing.add((Figure)tmpFig);
                    TasksPanel.this._lolaGUI._drawing.checkDamage();
                    LolaTask tmpTask = new LolaTask(tmpFig, TasksPanel.this._lolaGUI._drawing);
                    Vector<Object> newRow = new Vector<Object>();
                    newRow.add(new IndirectLolaResult(LolaResultStatus.UNCHECKED));
                    newRow.add(tmpTask);
                    ((DefaultTableModel)TasksPanel.this._taskTable.getModel()).addRow(newRow);
                } else {
                    _logger.error((Object)"[Lola GUI] No text, no task to add.");
                }
            }
        });
        JPanel addPanel = new JPanel();
        addPanel.setLayout(new BoxLayout(addPanel, 0));
        addPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        addPanel.add(newTask);
        addPanel.add(Box.createHorizontalStrut(5));
        addPanel.add(addButton);
        JButton updateButton = new JButton("Update Tasks");
        updateButton.setAlignmentX(0.5f);
        updateButton.setToolTipText("Parses the tasks in the current net drawing and displays them in the table.");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LolaFileCreator creator = new LolaFileCreator();
                Vector<LolaTask> tasks = creator.parseTasks(TasksPanel.this._lolaGUI._drawing);
                DefaultTableModel model = new DefaultTableModel();
                model.addColumn((Object)"task", tasks);
                model.addColumn((Object)"result", new Vector());
                model.setColumnIdentifiers(TASK_COLUMN_NAMES);
                TasksPanel.this._taskTable.setModel(model);
                TasksPanel.this.setupTaskTable();
            }
        });
        JButton checkButton = new JButton("Check Tasks");
        checkButton.setAlignmentX(0.5f);
        checkButton.setToolTipText("Checks the selected tasks and displays the result.");
        checkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < TasksPanel.this._taskTable.getRowCount(); ++i) {
                    LolaTask tmpTask = (LolaTask)TasksPanel.this._taskTable.getValueAt(i, 1);
                    _logger.info((Object)("[Lola TaskCheck] checking task " + tmpTask.toString()));
                    DirectLolaResult lolaResult = tmpTask.check(new LolaAnalyzer(TasksPanel.this._lolaGUI._lolaPath));
                    tmpTask.colorFigure();
                    TasksPanel.this._taskTable.setValueAt(lolaResult, i, 0);
                }
                TasksPanel.this._lolaGUI._drawing.checkDamage();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(updateButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(checkButton);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)addPanel, "First");
        this.add((Component)buttonPanel, "Last");
    }

    private void setupTaskTable() {
        LolaFileCreator creator = new LolaFileCreator();
        if (this._lolaGUI._drawing == null) {
            System.out.println("DRAWING IS NULL");
        }
        Vector<LolaTask> initialTasks = creator.parseTasks(this._lolaGUI._drawing);
        Collections.sort(initialTasks, new Comparator<LolaTask>(){

            @Override
            public int compare(LolaTask o1, LolaTask o2) {
                Rectangle r1 = o1.getFigure().displayBox();
                Rectangle r2 = o2.getFigure().displayBox();
                int result = r1.x == r2.x && r1.y == r2.y ? o1.toString().compareTo(o2.toString()) : (r1.y > r2.y || r1.y == r2.y && r1.x > r2.x ? 1 : -1);
                return result;
            }
        });
        Vector<IndirectLolaResult> initialResults = new Vector<IndirectLolaResult>();
        for (int i = 0; i < initialTasks.size(); ++i) {
            initialResults.add(new IndirectLolaResult(LolaResultStatus.UNCHECKED));
        }
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn((Object)"result", initialResults);
        model.addColumn((Object)"task", initialTasks);
        model.setColumnIdentifiers(TASK_COLUMN_NAMES);
        this._taskTable.setModel(model);
        this._taskTable.setFillsViewportHeight(true);
        this._taskTable.setRowHeight(20);
        this._taskTable.setIntercellSpacing(new Dimension(4, 4));
        this._taskTable.getColumnModel().getColumn(1).setPreferredWidth(350);
        this._taskTable.getColumnModel().getColumn(1).setMinWidth(350);
        this._taskTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer());
        this._taskTable.getColumnModel().getColumn(0).setMaxWidth(20);
        this._taskTable.getColumnModel().getColumn(0).setMinWidth(20);
        this._taskTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object o) {
                if (o instanceof LolaResult) {
                    LolaResult result = (LolaResult)o;
                    LolaResultStatus status = result.getStatus();
                    this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                    this.setText(status.toString().substring(0, 1));
                    if (result instanceof DirectLolaResult) {
                        StringBuffer tip = new StringBuffer("<html>");
                        DirectLolaResult lolaResult = (DirectLolaResult)result;
                        String output = lolaResult.getError();
                        tip.append(output.replaceAll("\n", "\n<br>"));
                        tip.append("</html>");
                        this.setToolTipText(tip.toString());
                    } else {
                        this.setToolTipText("No Output available.");
                    }
                    Color color = LolaGUIHelper.getStatusColor(status);
                    this.setBackground(color);
                } else {
                    _logger.error((Object)"[Lola GUI] This should use other renderer.");
                    super.setValue(o);
                }
            }
        });
    }
}

