/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.commands.CheckAllCommand;
import de.renew.lola2.gui.ChecklistPanel;
import de.renew.lola2.gui.MarkingEditorPanel;
import de.renew.lola2.gui.TasksPanel;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class LolaGUI
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(CheckAllCommand.class);
    String _lolaPath = "";
    private TasksPanel _generalPanel;
    private ChecklistPanel _checkListPanel;
    private MarkingEditorPanel _markEdPanel;
    CPNDrawing _drawing;

    public LolaGUI() throws HeadlessException {
        this.init();
    }

    public LolaGUI(GraphicsConfiguration gc) {
        super(gc);
        this.init();
    }

    public LolaGUI(String title) throws HeadlessException {
        super(title);
        this.init();
    }

    public LolaGUI(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.init();
    }

    public LolaGUI(String title, String path) {
        super(title);
        this._lolaPath = path;
        this.init();
    }

    public void init() {
        DrawApplication app = DrawPlugin.getGui();
        if (app.drawing() instanceof CPNDrawing) {
            this._drawing = (CPNDrawing)app.drawing();
            JTabbedPane tabs = new JTabbedPane();
            this._generalPanel = new TasksPanel(this);
            this._checkListPanel = new ChecklistPanel(this);
            this._markEdPanel = new MarkingEditorPanel(this);
            tabs.addTab("Checklist", this._checkListPanel);
            tabs.addTab("Marking Editor", this._markEdPanel);
            tabs.addTab("Tasks", this._generalPanel);
            this.add((Component)tabs, "Center");
            this.checkNow();
        } else {
            LOGGER.error((Object)"[Lola GUI] Could not initialize, no open CPNDrawing.");
        }
    }

    public void checkNow() {
        this._checkListPanel.updateChecklist();
        this._markEdPanel.updatePlaces();
    }
}

