/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import de.renew.gui.CPNDrawing;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.DirectLolaResult;
import de.renew.lola2.analysis.IndirectLolaResult;
import de.renew.lola2.analysis.LolaResultStatus;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUI;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.lola2.io.LolaImportFormat;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ChecklistPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(ChecklistPanel.class);
    private LolaGUI _lolaGUI;
    protected JLabel _livenessResultLabel = new JLabel();
    protected JLabel _deadlockFreedomResultLabel = new JLabel();
    protected JLabel _reversibilityResultLabel = new JLabel();
    protected JLabel _boundednessResultLabel = new JLabel();
    protected JLabel _quasiLivenessResultLabel = new JLabel();
    protected JLabel _nameOfNetLabel = new JLabel();
    private CheckListAction _checkListListener;

    public ChecklistPanel(LolaGUI lolaGUI) {
        this._lolaGUI = lolaGUI;
        this.setVisible(true);
        this.setup();
    }

    private void setup() {
        GridLayout checkListLayout = new GridLayout(7, 2, 10, 5);
        this.setLayout(checkListLayout);
        JLabel netnameLabel = new JLabel("Currently checking: ");
        JLabel quasiLivenessLabel = new JLabel("Quasi-Liveness");
        JLabel livenessLabel = new JLabel("Liveness");
        JLabel deadlockFreedomLabel = new JLabel("Deadlock freedom");
        JLabel reversibilityLabel = new JLabel("Reversibility");
        JLabel boundednessLabel = new JLabel("Boundedness");
        JLabel[] labels = new JLabel[]{quasiLivenessLabel, livenessLabel, deadlockFreedomLabel, reversibilityLabel, boundednessLabel, netnameLabel};
        JLabel[] results = new JLabel[]{this._quasiLivenessResultLabel, this._livenessResultLabel, this._deadlockFreedomResultLabel, this._reversibilityResultLabel, this._boundednessResultLabel, this._nameOfNetLabel};
        quasiLivenessLabel.setToolTipText("Is the net quasi-live (i.e. every transition non-dead in initial marking)?");
        livenessLabel.setToolTipText("Is the net live (i.e. for all reachable markings there is a firing sequence, so that every transition can be enabled)?");
        deadlockFreedomLabel.setToolTipText("Is the net deadlock-free?");
        reversibilityLabel.setToolTipText("Is the net reversible (is the initial marking a home state)?");
        boundednessLabel.setToolTipText("Is the net bounded?");
        for (int i = 0; i < labels.length; ++i) {
            labels[i].setHorizontalAlignment(4);
            this.add(labels[i]);
            results[i].setText("n.y.c");
            results[i].setForeground(Color.GRAY);
            this.add(results[i]);
        }
        JButton checkButton = new JButton("Check properties");
        this._checkListListener = new CheckListAction();
        checkButton.addActionListener(this._checkListListener);
        JButton ptnButton = new JButton("Show PTN projection");
        ptnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawApplication app = DrawPlugin.getGui();
                if (app.drawing() instanceof CPNDrawing) {
                    ChecklistPanel.this._lolaGUI._drawing = (CPNDrawing)app.drawing();
                    File netFile = new LolaFileCreator().writeTemporaryLolaFile(ChecklistPanel.this._lolaGUI._drawing);
                    LolaImportFormat lolaImporter = new LolaImportFormat();
                    try {
                        Drawing imported = lolaImporter.importFile(netFile.toURI().toURL());
                        app.showDrawingViewContainer(imported);
                    }
                    catch (MalformedURLException e3) {
                        LOGGER.error((Object)"[Lola GUI - Show PTN projection] Converting the file to a URL failed");
                        e3.printStackTrace();
                    }
                    catch (Exception e3) {
                        LOGGER.error((Object)"[Lola GUI - Show PTN projection] Something went wrong with the import");
                        e3.printStackTrace();
                    }
                } else {
                    LOGGER.error((Object)"[Lola GUI - Show PTN projection] Drawing must be CPNDrawing");
                }
            }
        });
        this.add(checkButton);
        this.add(ptnButton);
    }

    void updateChecklist() {
        this._checkListListener.actionPerformed(null);
    }

    class CheckListAction
    implements ActionListener {
        CheckListAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ChecklistPanel.this._nameOfNetLabel.setText("...");
            ChecklistPanel.this.update(ChecklistPanel.this.getGraphics());
            DrawApplication app = DrawPlugin.getGui();
            if (app.drawing() instanceof CPNDrawing) {
                ChecklistPanel.this._lolaGUI._drawing = (CPNDrawing)app.drawing();
            }
            LOGGER.info((Object)("[Lola] performing checklist action with drawing " + ChecklistPanel.this._lolaGUI._drawing.getName()));
            PropertyAnalyzer analyzer = new PropertyAnalyzer(ChecklistPanel.this._lolaGUI._lolaPath);
            File tmpLolaFile = new LolaFileCreator().writeTemporaryLolaFile(ChecklistPanel.this._lolaGUI._drawing);
            LOGGER.debug((Object)"[Lola Checklist] Check whether net is quasi-live");
            IndirectLolaResult quasiLivenessResult = analyzer.checkNetQuasiLiveness(tmpLolaFile);
            this.colorResultLabel(ChecklistPanel.this._quasiLivenessResultLabel, quasiLivenessResult.getStatus());
            if (quasiLivenessResult.getStatus() == LolaResultStatus.YES) {
                LOGGER.debug((Object)"[Lola Checklist] Check whether net is live");
                IndirectLolaResult livenessResult = analyzer.checkNetLiveness(tmpLolaFile, false);
                this.colorResultLabel(ChecklistPanel.this._livenessResultLabel, livenessResult.getStatus());
            } else {
                this.colorResultLabel(ChecklistPanel.this._livenessResultLabel, quasiLivenessResult.getStatus());
            }
            LOGGER.debug((Object)"[Lola Checklist] Check whether net is bounded");
            IndirectLolaResult boundednessResult = analyzer.checkNetBoundedness(tmpLolaFile);
            this.colorResultLabel(ChecklistPanel.this._boundednessResultLabel, boundednessResult.getStatus());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"[Lola Checklist] Check whether net is reversible");
            }
            DirectLolaResult reversibilityResult = analyzer.checkNetReversibility(tmpLolaFile);
            this.colorResultLabel(ChecklistPanel.this._reversibilityResultLabel, reversibilityResult.getStatus());
            LOGGER.debug((Object)"[Lola Checklist] Check whether net is deadlock free");
            DirectLolaResult deadlockFreedomResult = analyzer.checkNetDeadlockFreedom(tmpLolaFile);
            this.colorResultLabel(ChecklistPanel.this._deadlockFreedomResultLabel, deadlockFreedomResult.getStatus());
        }

        public void colorResultLabel(JLabel label, LolaResultStatus status) {
            Color color = LolaGUIHelper.getStatusColor(status);
            label.setForeground(color);
            switch (status) {
                case YES: {
                    label.setText("[yes]");
                    break;
                }
                case NO: {
                    label.setText("[no]");
                    break;
                }
                case ERROR: {
                    label.setText("ERROR");
                    label.setToolTipText("An error occured, check the console output for more information.");
                    LOGGER.error((Object)"[Lola CheckList] The lola call resulted in an unexpected result.");
                    break;
                }
                case UNCHECKED: {
                    label.setText("n.y.c");
                    break;
                }
                case INFEASIBLE: {
                    label.setText("[n/a]");
                }
            }
            ChecklistPanel.this._nameOfNetLabel.setText(ChecklistPanel.this._lolaGUI._drawing.getName());
        }
    }
}

