/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola2.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.lola2.LolaFileCreator;
import de.renew.lola2.analysis.LolaResult;
import de.renew.lola2.analysis.PropertyAnalyzer;
import de.renew.lola2.gui.LolaGUIHelper;
import de.renew.plugin.command.CLCommand;
import java.awt.Color;
import java.io.File;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class CheckAllCommand
extends Command
implements CLCommand {
    private String _lolaPath;
    private static Logger _logger = Logger.getLogger(CheckAllCommand.class);

    public CheckAllCommand(String name, String path) {
        super(name);
        this._lolaPath = path;
    }

    public void execute() {
        DrawApplication app = DrawPlugin.getGui();
        CPNDrawing drawing = (CPNDrawing)app.drawing();
        app.getUndoRedoManager().prepareUndoSnapshot(app.drawing());
        PropertyAnalyzer analyzer = new PropertyAnalyzer(this._lolaPath);
        LolaFileCreator creator = new LolaFileCreator();
        File netFile = creator.writeTemporaryLolaFile(drawing);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)(CheckAllCommand.class.getSimpleName() + ": temp file name: " + netFile.getPath()));
        }
        FigureEnumeration figures = drawing.figures();
        boolean changed = false;
        while (figures.hasMoreElements()) {
            Figure fig = (Figure)figures.nextElement();
            LolaResult result = null;
            if (fig instanceof PlaceFigure) {
                if (fig instanceof VirtualPlaceFigure) continue;
                String placeName = creator.getNameForFigure(fig);
                result = analyzer.checkPlaceBoundedness(placeName, netFile);
            } else if (fig instanceof TransitionFigure) {
                String transitionName = creator.getNameForFigure(fig);
                result = analyzer.checkTransitionLiveness(transitionName, netFile);
            }
            if (result == null) continue;
            switch (result.getStatus()) {
                case YES: {
                    LolaGUIHelper.colorFigure(fig, Color.GREEN);
                    break;
                }
                case NO: {
                    LolaGUIHelper.colorFigure(fig, Color.RED);
                    break;
                }
            }
            changed = true;
        }
        if (changed) {
            DrawPlugin.getGui().view().checkDamage();
            app.getUndoRedoManager().commitUndoSnapshot((Drawing)drawing);
        }
    }

    public void execute(String[] args, PrintStream response) {
    }

    public String getDescription() {
        return "Check all places and transitions.";
    }
}

