/*
 * Decompiled with CFR 0.152.
 */
package de.renew.layoutwindow;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import de.renew.layoutwindow.LayoutWindow;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.annotations.Inject;
import de.renew.plugin.di.DIPlugin;
import de.renew.windowmanagement.Workbench;
import javax.swing.JMenuItem;

public class LayoutWindowPlugin
extends DIPlugin {
    private static final String LAYOUT_WINDOW = "de.renew.layoutwindow.enable";
    private static final String LAYOUT_WINDOW_MENU_ITEM = "de.renew.layoutwindow.menuitem";
    private static final String LAYOUT_WINDOW_SEPARATOR = "de.renew.layoutwindow.separator";
    private final Workbench _workbench;

    @Inject
    public LayoutWindowPlugin(Workbench workbench) {
        this._workbench = workbench;
    }

    public void init() {
        if (PluginProperties.getUserProperties().getBoolProperty(LAYOUT_WINDOW, true)) {
            this.addLayoutWindowMenuEntry();
        }
    }

    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }
        MenuManager mm = current.getMenuManager();
        mm.unregisterMenu(LAYOUT_WINDOW_SEPARATOR);
        mm.unregisterMenu(LAYOUT_WINDOW_MENU_ITEM);
        return true;
    }

    private void addLayoutWindowMenuEntry() {
        JMenuItem mi = new JMenuItem("Layout Window");
        mi.addActionListener(e -> LayoutWindow.openLayoutWindow(this._workbench));
        MenuManager.SeparatorFactory sepFac = new MenuManager.SeparatorFactory("de.renew.layoutwindow");
        JMenuItem separator = sepFac.createSeparator();
        if (DrawPlugin.getCurrent() != null) {
            MenuManager mm = DrawPlugin.getCurrent().getMenuManager();
            mm.registerMenu("Layout", separator, LAYOUT_WINDOW_SEPARATOR);
            mm.registerMenu("Layout", mi, LAYOUT_WINDOW_MENU_ITEM);
        }
    }
}

