/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.imagenetdiff.EPSDiffClCommand;
import de.renew.imagenetdiff.EPSDiffCommand;
import de.renew.imagenetdiff.ImageNetDiffClCommand;
import de.renew.imagenetdiff.PNGDiffCommand;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.net.URL;
import javax.swing.JMenuItem;

public class ImageNetDiffPlugin
extends PluginAdapter {
    private CommandMenu _menu;
    private int _blockCounter;

    public ImageNetDiffPlugin(URL url) throws PluginException {
        super(url);
    }

    public ImageNetDiffPlugin(PluginProperties props) {
        super(props);
    }

    public void init() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return;
        }
        PluginManager manager = PluginManager.getInstance();
        manager.addCLCommand("diff", (CLCommand)new ImageNetDiffClCommand());
        manager.addCLCommand("epsdiff", (CLCommand)new EPSDiffClCommand());
        MenuManager mm = current.getMenuManager();
        this._menu = new CommandMenu("Net Diff");
        this._menu.putClientProperty((Object)"ch.ifa.draw.menu.id", (Object)"de.renew.imagenetdiff");
        this._menu.add((Command)new PNGDiffCommand());
        this._menu.add((Command)new EPSDiffCommand());
        this._menu.add((Command)new VersionInfoCommand((IPlugin)this));
        mm.registerMenu("Tools", (JMenuItem)this._menu);
    }

    public boolean cleanup() {
        DrawPlugin current = DrawPlugin.getCurrent();
        if (current == null) {
            return true;
        }
        MenuManager mm = current.getMenuManager();
        if (mm != null && this._menu != null) {
            mm.unregisterMenu((JMenuItem)this._menu);
        }
        PluginManager manager = PluginManager.getInstance();
        manager.removeCLCommand("diff");
        manager.removeCLCommand("epsdiff");
        return true;
    }

    public synchronized boolean canShutDown() {
        return true;
    }

    public void addBlock() {
        if (this._blockCounter++ == 0) {
            PluginManager manager = PluginManager.getInstance();
            manager.blockExit((IPlugin)this);
        }
    }

    public void removeBlock() {
        if (--this._blockCounter <= 0) {
            PluginManager manager = PluginManager.getInstance();
            manager.exitOk((IPlugin)this);
            this._blockCounter = 0;
        }
    }
}

