# GuiPrompt

## User Guide

This plugin works in the same way as the Prompt plugin does, only that it does not
present a command line but a dialog in which the user can enter its command.  
A menu entry which shows this dialog is added to the gui when the plugin is initialized.

### Features

- Creates a dialog window in which the user can enter commands
- The dialog lists all executed commands and additional information if the command needs further information or can't be executed for some reason
- Provides a clear button to clean up the _Execution feedback_ section

### Example Usage

1. Open the plugin _GuiPrompt_ under the menu entry > Plugins > GuiPrompt
2. Now open the navigator by typing the command _navigator_ into the text field area and confirm the input by clicking on the _execute_ button - the navigator should appear

### Provided Commands

- `guiprompt` - This command can be used to open the Prompt dialog

### Installation

Install _GuiPrompt_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

- `Loader` : (mandated)
- `CH` : Provides all GUI elements which are needed for this plugin (e.g. menu entry and dialog window)
- `log4j` : Logging Framework

### Configuration

- none

## Developer Guide

### Core Classes

- `de.renew.guiprompt.GuiPromptPlugin` : this class is accountable for the Gui and commands. It initializes the Gui and tries to execute the typed commands.

### How to Extend

There are no interfaces which could extend the _GuiPrompt_ plugin, yet.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- There are several commands which Renew provides. Type `help` into the GuiPrompt to receive a list of commands.

<!-- Contribution Info -->

<!-- License -->


