/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.impl;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.automatalib.commons.util.collections.UnmodifiableListIterator;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

public class ListAlphabet<I>
extends AbstractAlphabet<I> {
    private final List<? extends I> list;

    public ListAlphabet(List<? extends I> list) {
        this.list = list;
    }

    @Override
    public I getSymbol(int index) {
        try {
            return this.list.get(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new IllegalArgumentException(ioobe);
        }
    }

    @Override
    public int getSymbolIndex(I symbol) {
        int idx = this.list.indexOf(symbol);
        if (idx == -1) {
            throw new IllegalArgumentException("Symbol " + symbol + " is not contained in the alphabet");
        }
        return idx;
    }

    @Override
    public boolean containsSymbol(I symbol) {
        return this.list.contains(symbol);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<I> iterator() {
        return Iterators.unmodifiableIterator(this.list.iterator());
    }

    @Override
    public ListIterator<I> listIterator(int index) {
        return new UnmodifiableListIterator<I>(this.list.listIterator(index));
    }
}

