/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import net.automatalib.graphs.Graph;
import net.automatalib.serialization.dot.GraphDOT;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.visualization.VisualizationProvider;
import net.automatalib.visualization.dot.DOT;

public class GraphVizSwingVisualizationProvider
implements VisualizationProvider {
    public static final String ID = "graphviz-swing";
    private static final int PRIORITY = 11;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public int getPriority() {
        return 11;
    }

    @Override
    public boolean checkUsable() {
        return DOT.checkUsable();
    }

    @Override
    public <N, E> void visualize(Graph<N, E> graph, List<VisualizationHelper<N, ? super E>> additionalHelpers, boolean modal, Map<String, String> visOptions) {
        try (Writer w = DOT.createDotWriter(modal);){
            GraphDOT.write(graph, (Appendable)w, additionalHelpers);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Error rendering graph: " + ex.getMessage());
        }
    }
}

