/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.random;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.automatalib.automata.MutableAutomaton;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.commons.util.random.RandomUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RandomAutomatonGenerator<S, I, T, SP, TP, A extends MutableAutomaton<S, I, T, SP, TP>> {
    protected final RandomUtil random;
    protected final List<? extends I> inputs;
    protected final List<? extends SP> spList;
    protected final List<? extends TP> tpList;
    protected final ArrayList<S> states;
    protected final A automaton;

    public RandomAutomatonGenerator(Random random, Collection<? extends I> inputs, Collection<? extends SP> stateProps, Collection<? extends TP> transProps, A automaton) {
        this.random = new RandomUtil(random);
        this.spList = CollectionsUtil.randomAccessList(stateProps);
        this.tpList = CollectionsUtil.randomAccessList(transProps);
        this.inputs = CollectionsUtil.randomAccessList(inputs);
        this.states = new ArrayList();
        this.automaton = automaton;
    }

    public A getAutomaton() {
        return this.automaton;
    }

    protected @Nullable TP randomTransProperty() {
        return this.random.choose(this.tpList);
    }

    protected @Nullable S randomState() {
        return this.random.choose(this.states);
    }

    protected @Nullable S randomDistinctState(int stateIdx) {
        if (this.states.size() == 1) {
            return null;
        }
        int idx = this.random.getRandom().nextInt(this.states.size() - 1);
        if (idx >= stateIdx) {
            ++idx;
        }
        return this.states.get(idx);
    }

    protected @Nullable I randomInput() {
        return this.random.choose(this.inputs);
    }

    public void addStates(int numStates) {
        this.states.ensureCapacity(this.states.size() + numStates);
        for (int i = 0; i < numStates; ++i) {
            Object state = this.automaton.addState(this.randomStateProperty());
            this.states.add(state);
        }
    }

    protected @Nullable SP randomStateProperty() {
        return this.random.choose(this.spList);
    }

    public void chooseInitial() {
        S init = this.random.choose(this.states);
        this.automaton.setInitial(init, true);
    }

    public void chooseInitials(int num) {
        List<S> inits = this.random.sampleUnique(this.states, num);
        for (S init : inits) {
            this.automaton.setInitial(init, true);
        }
    }
}

