/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.minimizer.hopcroft;

import net.automatalib.automata.AutomatonCreator;
import net.automatalib.automata.DeterministicAutomaton;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.InputAlphabetHolder;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.MutableDFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.MutableMealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.util.partitionrefinement.AutomatonInitialPartitioning;
import net.automatalib.util.partitionrefinement.PaigeTarjan;
import net.automatalib.util.partitionrefinement.PaigeTarjanExtractors;
import net.automatalib.util.partitionrefinement.PaigeTarjanInitializers;
import net.automatalib.words.Alphabet;

public final class HopcroftMinimization {
    private HopcroftMinimization() {
    }

    public static <S, I, A extends DFA<S, I> & InputAlphabetHolder<I>> CompactDFA<I> minimizeDFA(A dfa) {
        return HopcroftMinimization.minimizeDFA(dfa, PruningMode.PRUNE_AFTER);
    }

    public static <S, I, A extends DFA<S, I> & InputAlphabetHolder<I>> CompactDFA<I> minimizeDFA(A dfa, PruningMode pruningMode) {
        return HopcroftMinimization.minimizeDFA(dfa, ((InputAlphabetHolder<I>)dfa).getInputAlphabet(), pruningMode);
    }

    public static <I> CompactDFA<I> minimizeDFA(DFA<?, I> dfa, Alphabet<I> alphabet) {
        return HopcroftMinimization.minimizeDFA(dfa, alphabet, PruningMode.PRUNE_AFTER);
    }

    public static <I> CompactDFA<I> minimizeDFA(DFA<?, I> dfa, Alphabet<I> alphabet, PruningMode pruningMode) {
        return (CompactDFA)HopcroftMinimization.minimizeDFA(dfa, alphabet, pruningMode, new CompactDFA.Creator());
    }

    public static <A extends MutableDFA<?, I>, I> A minimizeDFA(DFA<?, I> dfa, Alphabet<I> alphabet, PruningMode pruningMode, AutomatonCreator<A, I> creator) {
        return (A)((MutableDFA)HopcroftMinimization.minimizeUniversal(dfa, alphabet, creator, AutomatonInitialPartitioning.BY_STATE_PROPERTY, pruningMode));
    }

    public static <S, I, T, O, A extends MealyMachine<S, I, T, O> & InputAlphabetHolder<I>> CompactMealy<I, O> minimizeMealy(A mealy) {
        return HopcroftMinimization.minimizeMealy(mealy, PruningMode.PRUNE_AFTER);
    }

    public static <S, I, T, O, A extends MealyMachine<S, I, T, O> & InputAlphabetHolder<I>> CompactMealy<I, O> minimizeMealy(A mealy, PruningMode pruningMode) {
        return HopcroftMinimization.minimizeMealy(mealy, ((InputAlphabetHolder<I>)mealy).getInputAlphabet(), pruningMode);
    }

    public static <I, O> CompactMealy<I, O> minimizeMealy(MealyMachine<?, I, ?, O> mealy, Alphabet<I> alphabet) {
        return HopcroftMinimization.minimizeMealy(mealy, alphabet, PruningMode.PRUNE_AFTER);
    }

    public static <I, O> CompactMealy<I, O> minimizeMealy(MealyMachine<?, I, ?, O> mealy, Alphabet<I> alphabet, PruningMode pruningMode) {
        return (CompactMealy)HopcroftMinimization.minimizeMealy(mealy, alphabet, pruningMode, new CompactMealy.Creator());
    }

    public static <A extends MutableMealyMachine<?, I, ?, O>, I, O> A minimizeMealy(MealyMachine<?, I, ?, O> mealy, Alphabet<I> alphabet, PruningMode pruningMode, AutomatonCreator<A, I> creator) {
        return (A)((MutableMealyMachine)HopcroftMinimization.minimizeUniversal(mealy, alphabet, creator, AutomatonInitialPartitioning.BY_TRANSITION_PROPERTIES, pruningMode));
    }

    public static <I, T, SP, TP, A extends MutableDeterministic<?, I, ?, SP, TP>> A minimizeUniversal(UniversalDeterministicAutomaton<?, I, T, SP, TP> automaton, Alphabet<I> alphabet, AutomatonCreator<A, I> creator, AutomatonInitialPartitioning ap, PruningMode pruningMode) {
        PaigeTarjan pt = new PaigeTarjan();
        DeterministicAutomaton.FullIntAbstraction abs = automaton.fullIntAbstraction((Alphabet)alphabet);
        PaigeTarjanInitializers.initCompleteDeterministic(pt, abs, ap, pruningMode == PruningMode.PRUNE_BEFORE);
        pt.initWorklist(false);
        pt.computeCoarsestStablePartition();
        A result = PaigeTarjanExtractors.toDeterministic(pt, creator, alphabet, abs, ((UniversalDeterministicAutomaton.FullIntAbstraction)abs)::getStateProperty, ((UniversalDeterministicAutomaton.FullIntAbstraction)abs)::getTransitionProperty, pruningMode == PruningMode.PRUNE_AFTER);
        return result;
    }

    public static enum PruningMode {
        PRUNE_BEFORE,
        PRUNE_AFTER,
        DONT_PRUNE;

    }
}

