/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.ts.powerset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.automatalib.ts.PowersetViewTS;
import net.automatalib.ts.TransitionSystem;

public class DirectPowersetDTS<S, I, T>
implements PowersetViewTS<Set<S>, I, Set<T>, S, T> {
    private final TransitionSystem<S, I, T> ts;

    public DirectPowersetDTS(TransitionSystem<S, I, T> ts) {
        this.ts = ts;
    }

    @Override
    public Set<S> getInitialState() {
        return this.ts.getInitialStates();
    }

    @Override
    public Set<S> getSuccessor(Set<T> transition) {
        HashSet<S> result = new HashSet<S>();
        for (T trans : transition) {
            result.add(this.ts.getSuccessor(trans));
        }
        return result;
    }

    @Override
    public Set<S> getSuccessor(Set<S> state, I input) {
        HashSet<S> result = new HashSet<S>();
        for (S s2 : state) {
            Collection<T> transitions = this.ts.getTransitions(s2, input);
            for (T t : transitions) {
                result.add(this.ts.getSuccessor(t));
            }
        }
        return result;
    }

    @Override
    public Set<T> getTransition(Set<S> state, I input) {
        HashSet<T> result = new HashSet<T>();
        for (S s2 : state) {
            Collection<T> transitions = this.ts.getTransitions(s2, input);
            result.addAll(transitions);
        }
        return result;
    }

    @Override
    public Collection<S> getOriginalStates(Set<S> state) {
        return state;
    }

    @Override
    public Collection<T> getOriginalTransitions(Set<T> transition) {
        return transition;
    }
}

