/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.automatalib.commons.util.strings.StringUtil;
import net.automatalib.serialization.taf.parser.InternalTAFParserConstants;
import net.automatalib.serialization.taf.parser.InternalTAFParserTokenManager;
import net.automatalib.serialization.taf.parser.ParseException;
import net.automatalib.serialization.taf.parser.SimpleCharStream;
import net.automatalib.serialization.taf.parser.TAFBuilderDFA;
import net.automatalib.serialization.taf.parser.TAFBuilderMealy;
import net.automatalib.serialization.taf.parser.TAFFormatException;
import net.automatalib.serialization.taf.parser.TAFParseDiagnosticListener;
import net.automatalib.serialization.taf.parser.Token;
import net.automatalib.serialization.taf.parser.Type;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;
import net.automatalib.words.impl.GrowingMapAlphabet;

class InternalTAFParser
implements InternalTAFParserConstants {
    private TAFParseDiagnosticListener listener;
    public InternalTAFParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public void error(String fmtString, Object ... args) {
        if (this.listener != null) {
            this.listener.error(this.getLine(), this.getCol(), fmtString, args);
        }
    }

    public void warning(String fmtString, Object ... args) {
        if (this.listener != null) {
            this.listener.error(this.getLine(), this.getCol(), fmtString, args);
        }
    }

    public void fatal(String fmtString, Object ... args) {
        throw new TAFFormatException("At line " + this.getLine() + ", column " + this.getCol() + ": " + MessageFormat.format(fmtString, args));
    }

    public void setDiagnosticListener(TAFParseDiagnosticListener listener) {
        this.listener = listener;
    }

    private int getLine() {
        return this.token.beginLine;
    }

    private int getCol() {
        return this.token.beginColumn;
    }

    public final Alphabet<String> charStringRange() throws ParseException {
        this.jj_consume_token(7);
        char l = this.singleChar();
        this.jj_consume_token(9);
        char r = this.singleChar();
        this.jj_consume_token(8);
        if (l > r) {
            this.error("Invalid character range [{0}..{1}]", Character.valueOf(l), Character.valueOf(r));
            return null;
        }
        return Alphabets.closedCharStringRange(l, r);
    }

    public final Alphabet<String> stringSet() throws ParseException {
        GrowingMapAlphabet<String> result = new GrowingMapAlphabet<String>();
        this.jj_consume_token(10);
        String s2 = this.string();
        result.add(s2);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            s2 = this.string();
            result.add(s2);
        }
        this.jj_consume_token(11);
        return result;
    }

    public final char singleChar() throws ParseException {
        Token t = this.jj_consume_token(16);
        return t.toString().charAt(0);
    }

    public final Alphabet<String> stringCollection() throws ParseException {
        Alphabet<String> sc;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                sc = this.charStringRange();
                break;
            }
            case 10: {
                sc = this.stringSet();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                String s2 = this.string();
                sc = Alphabets.singleton(s2);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return sc;
    }

    public final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                Token t = this.jj_consume_token(17);
                return t.toString();
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                return t.toString();
            }
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String string() throws ParseException {
        String s2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: 
            case 17: {
                s2 = this.identifier();
                break;
            }
            case 20: {
                Token t = this.jj_consume_token(20);
                s2 = StringUtil.unescapeQuotes(t.toString());
                break;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                s2 = t.toString();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return s2;
    }

    public final Set<String> stateOpts() throws ParseException {
        Set<String> result = Collections.emptySet();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                String s2 = this.identifier();
                result = new HashSet<String>();
                result.add(s2);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(12);
                    s2 = this.identifier();
                    result.add(s2);
                }
                this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        return result;
    }

    public final Type type() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                return Type.DFA;
            }
            case 6: {
                this.jj_consume_token(6);
                return Type.MEALY;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void dfa(TAFBuilderDFA builder) throws ParseException {
        this.jj_consume_token(5);
        this.dfaBody(builder);
    }

    public final void dfaBody(TAFBuilderDFA builder) throws ParseException {
        Alphabet<String> alphabet = this.stringCollection();
        if (alphabet == null) {
            this.fatal("No valid alphabet specified", new Object[0]);
        }
        builder.init(alphabet);
        this.jj_consume_token(10);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.stateDeclDfa(builder);
        }
        this.jj_consume_token(11);
    }

    public final void stateDeclDfa(TAFBuilderDFA builder) throws ParseException {
        String id = this.identifier();
        Set<String> opts = this.stateOpts();
        builder.declareState(id, opts);
        this.transBlockDfa(builder, id);
    }

    public final void transBlockDfa(TAFBuilderDFA builder, String source) throws ParseException {
        this.jj_consume_token(10);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 10: 
                case 16: 
                case 17: 
                case 18: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.transDeclDfa(builder, source);
        }
        this.jj_consume_token(11);
    }

    public final void transDeclDfa(TAFBuilderDFA builder, String source) throws ParseException {
        Alphabet<String> symbols = this.stringCollection();
        this.jj_consume_token(15);
        String tgt = this.identifier();
        if (symbols != null) {
            builder.addTransitions(source, symbols, tgt);
        }
    }

    public final void wildcardTransDeclDfa(TAFBuilderDFA builder, String source) throws ParseException {
        this.jj_consume_token(14);
        this.jj_consume_token(15);
        String tgt = this.identifier();
        builder.addWildcardTransitions(source, tgt);
    }

    public final void mealy(TAFBuilderMealy builder) throws ParseException {
        this.jj_consume_token(6);
        this.mealyBody(builder);
    }

    public final void mealyBody(TAFBuilderMealy builder) throws ParseException {
        Alphabet<String> alphabet = this.stringCollection();
        if (alphabet == null) {
            this.fatal("No valid alphabet specified", new Object[0]);
        }
        builder.init(alphabet);
        this.jj_consume_token(10);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.stateDeclMealy(builder);
        }
        this.jj_consume_token(11);
    }

    public final void stateDeclMealy(TAFBuilderMealy builder) throws ParseException {
        String id = this.identifier();
        Set<String> opts = this.stateOpts();
        builder.declareState(id, opts);
        this.transBlockMealy(builder, id);
    }

    public final void transBlockMealy(TAFBuilderMealy builder, String source) throws ParseException {
        this.jj_consume_token(10);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 10: 
                case 16: 
                case 17: 
                case 18: 
                case 20: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block6;
                }
            }
            this.transDeclMealy(builder, source);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.wildcardTransDeclMealy(builder, source);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(11);
    }

    public final void transDeclMealy(TAFBuilderMealy builder, String source) throws ParseException {
        String output = null;
        Alphabet<String> symbols = this.stringCollection();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                output = this.string();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(15);
        String tgt = this.identifier();
        if (symbols != null) {
            builder.addTransitions(source, symbols, output, tgt);
        }
    }

    public final void wildcardTransDeclMealy(TAFBuilderMealy builder, String source) throws ParseException {
        String output = null;
        this.jj_consume_token(14);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                output = this.string();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(15);
        String tgt = this.identifier();
        builder.addWildcardTransitions(source, output, tgt);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4096, 1508480, 196608, 0x170000, 4096, 128, 96, 196608, 1508480, 196608, 1508480, 16384, 8192, 8192};
    }

    public InternalTAFParser(InputStream stream) {
        this(stream, null);
    }

    public InternalTAFParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new InternalTAFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public InternalTAFParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new InternalTAFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public InternalTAFParser(InternalTAFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InternalTAFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[28];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 14; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 28; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        InternalTAFParser.jj_la1_init_0();
    }
}

