/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.fsm.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.commons.util.Pair;
import net.automatalib.serialization.ModelDeserializer;
import net.automatalib.serialization.fsm.parser.AbstractFSMParser;
import net.automatalib.words.Alphabet;
import net.automatalib.words.impl.Alphabets;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractFSM2MealyParser<I, O>
extends AbstractFSMParser<I>
implements ModelDeserializer<CompactMealy<I, O>> {
    private final Function<String, O> outputParser;
    private final Map<Pair<Integer, I>, Pair<O, Integer>> transitions = new HashMap<Pair<Integer, I>, Pair<O, Integer>>();
    private final SortedSet<Integer> states = new TreeSet<Integer>();

    protected AbstractFSM2MealyParser(@Nullable Collection<? extends I> targetInputs, Function<String, I> inputParser, Function<String, O> outputParser) {
        super(targetInputs, inputParser);
        this.outputParser = outputParser;
    }

    protected Function<String, O> getOutputParser() {
        return this.outputParser;
    }

    protected Map<Pair<Integer, I>, Pair<O, Integer>> getTransitions() {
        return this.transitions;
    }

    protected SortedSet<Integer> getStates() {
        return this.states;
    }

    @Override
    protected void parseDataDefinition(StreamTokenizer streamTokenizer) {
    }

    @Override
    protected void checkDataDefinitions(StreamTokenizer streamTokenizer) {
    }

    @Override
    protected void parseStateVector(StreamTokenizer streamTokenizer) {
        this.getStates().add(this.getPartLineNumber());
    }

    @Override
    protected void checkStateVectors(StreamTokenizer streamTokenizer) {
    }

    protected CompactMealy<I, O> parseMealy(Reader reader) throws IOException {
        this.parse(reader);
        Alphabet alphabet = this.targetInputs != null ? Alphabets.fromCollection(this.targetInputs) : Alphabets.fromCollection(this.getInputs());
        CompactMealy mealy = new CompactMealy(alphabet);
        HashMap<Integer, Integer> stateMap = new HashMap<Integer, Integer>();
        mealy.setInitialState(stateMap.computeIfAbsent((Integer)this.states.iterator().next(), i -> (Integer)mealy.addState()));
        this.getTransitions().entrySet().stream().filter(e -> alphabet.containsSymbol(((Pair)e.getKey()).getSecond())).forEach(e -> {
            Integer from = stateMap.computeIfAbsent((Integer)((Pair)e.getKey()).getFirst(), i -> (Integer)mealy.addState());
            Integer to = stateMap.computeIfAbsent((Integer)((Pair)e.getValue()).getSecond(), i -> (Integer)mealy.addState());
            Object i2 = ((Pair)e.getKey()).getSecond();
            Object o = ((Pair)e.getValue()).getFirst();
            mealy.addTransition(from, i2, to, o);
        });
        this.states.clear();
        this.transitions.clear();
        return mealy;
    }

    @Override
    public CompactMealy<I, O> readModel(InputStream is) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader(is);){
            CompactMealy<I, O> compactMealy = this.parseMealy(r);
            return compactMealy;
        }
    }
}

