/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.automatalib.commons.util.IOUtil;

public interface ModelDeserializer<M> {
    public M readModel(InputStream var1) throws IOException;

    default public M readModel(URL url) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream(url.openStream());){
            M m3 = this.readModel(is);
            return m3;
        }
    }

    default public M readModel(File f) throws IOException {
        try (InputStream is = IOUtil.asBufferedInputStream(f);){
            M m3 = this.readModel(is);
            return m3;
        }
    }

    default public M readModel(byte[] buf) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buf);){
            M m3 = this.readModel(is);
            return m3;
        }
    }
}

