/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.monitor;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.impl.compact.CompactDFA;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSminDFA;
import net.automatalib.modelcheckers.ltsmin.LTSminLTLParser;
import net.automatalib.modelcheckers.ltsmin.monitor.AbstractLTSminMonitor;
import net.automatalib.serialization.fsm.parser.FSM2DFAParser;
import net.automatalib.serialization.fsm.parser.FSMFormatException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTSminMonitorDFA<I>
extends AbstractLTSminMonitor<I, DFA<?, I>, DFA<?, I>>
implements LTSminDFA<I, DFA<?, I>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LTSminMonitorDFA.class);

    public LTSminMonitorDFA(boolean keepFiles, Function<String, I> string2Input) {
        super(keepFiles, string2Input);
    }

    @Override
    protected void verifyFormula(String formula) {
        LTSminLTLParser.requireValidLetterFormula(formula);
    }

    @Override
    public @Nullable DFA<?, I> findCounterExample(DFA<?, I> automaton, Collection<? extends I> inputs, String property) {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm == null) {
            return null;
        }
        try {
            CompactDFA result = (CompactDFA)FSM2DFAParser.getParser(inputs, this.getString2Input(), "label", "accept").readModel(fsm);
            for (Integer state : result) {
                boolean deadlocks = inputs.stream().noneMatch(i -> result.getSuccessor(state, i) != null);
                result.setAccepting(state, deadlocks);
            }
            CompactDFA compactDFA = result;
            return compactDFA;
        }
        catch (IOException | FSMFormatException e) {
            throw new ModelCheckingException(e);
        }
        finally {
            if (!this.isKeepFiles() && !fsm.delete()) {
                LOGGER.warn("Could not delete file: " + fsm.getAbsolutePath());
            }
        }
    }
}

