/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelcheckers.ltsmin.ltl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.exception.ModelCheckingException;
import net.automatalib.modelcheckers.ltsmin.LTSminLTLParser;
import net.automatalib.modelcheckers.ltsmin.LTSminMealy;
import net.automatalib.modelcheckers.ltsmin.ltl.AbstractLTSminLTL;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.modelchecking.ModelCheckerLasso;
import net.automatalib.modelchecking.lasso.MealyLassoImpl;
import net.automatalib.serialization.fsm.parser.FSMFormatException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLTSminLTLMealy<I, O>
extends AbstractLTSminLTL<I, MealyMachine<?, I, ?, O>, Lasso.MealyLasso<I, O>>
implements ModelCheckerLasso.MealyModelCheckerLasso<I, O, String>,
LTSminMealy<I, O, Lasso.MealyLasso<I, O>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLTSminLTLMealy.class);
    private final Function<String, O> string2Output;
    private Collection<? super O> skipOutputs;

    protected AbstractLTSminLTLMealy(boolean keepFiles, Function<String, I> string2Input, Function<String, O> string2Output, int minimumUnfolds, double multiplier, Collection<? super O> skipOutputs) {
        super(keepFiles, string2Input, minimumUnfolds, multiplier);
        this.string2Output = string2Output;
        this.skipOutputs = skipOutputs;
    }

    @Override
    public Function<String, O> getString2Output() {
        return this.string2Output;
    }

    @Override
    public Collection<? super O> getSkipOutputs() {
        return this.skipOutputs;
    }

    @Override
    public void setSkipOutputs(Collection<? super O> skipOutputs) {
        this.skipOutputs = skipOutputs;
    }

    @Override
    protected void verifyFormula(String formula) {
        LTSminLTLParser.requireValidIOFormula(formula);
    }

    @Override
    public @Nullable Lasso.MealyLasso<I, O> findCounterExample(MealyMachine<?, I, ?, O> automaton, Collection<? extends I> inputs, String property) {
        File fsm = this.findCounterExampleFSM(automaton, inputs, property);
        if (fsm == null) {
            return null;
        }
        try {
            CompactMealy<? extends I, O> mealy = this.fsm2Mealy(fsm, automaton, inputs);
            MealyLassoImpl mealyLassoImpl = new MealyLassoImpl(mealy, inputs, this.computeUnfolds(automaton.size()));
            return mealyLassoImpl;
        }
        catch (IOException | FSMFormatException e) {
            throw new ModelCheckingException(e);
        }
        finally {
            if (!this.isKeepFiles() && !fsm.delete()) {
                LOGGER.warn("Could not delete file: " + fsm.getAbsolutePath());
            }
        }
    }
}

