/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.dag;

import java.io.Serializable;
import net.automatalib.incremental.mealy.dag.StateSignature;

public final class State<O>
implements Serializable {
    private final StateSignature<O> signature;
    private int numIncoming;

    public State(StateSignature<O> signature) {
        this.signature = signature;
    }

    public void increaseIncoming() {
        ++this.numIncoming;
    }

    public void decreaseIncoming() {
        --this.numIncoming;
    }

    public int getNumIncoming() {
        return this.numIncoming;
    }

    public boolean isConfluence() {
        return this.numIncoming > 1;
    }

    public State<O> getSuccessor(int idx) {
        return ((State[])this.signature.successors.array)[idx];
    }

    public O getOutput(int idx) {
        return (O)this.signature.outputs.array[idx];
    }

    public StateSignature<O> getSignature() {
        return this.signature;
    }

    boolean ensureInputCapacity(int capacity) {
        return this.signature.successors.ensureCapacity(capacity) | this.signature.outputs.ensureCapacity(capacity);
    }
}

