/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graphs.base.compact;

import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.graphs.base.compact.AbstractCompactGraph;
import net.automatalib.graphs.base.compact.CompactEdge;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompactGraph<@Nullable NP, @Nullable EP>
extends AbstractCompactGraph<CompactEdge<EP>, NP, EP> {
    private final ResizingArrayStorage<NP> nodeProperties;

    public CompactGraph() {
        this.nodeProperties = new ResizingArrayStorage<Object>(Object.class);
    }

    public CompactGraph(int initialCapacity) {
        super(initialCapacity);
        this.nodeProperties = new ResizingArrayStorage<Object>(Object.class, initialCapacity);
    }

    @Override
    public void setNodeProperty(int node, @Nullable NP property) {
        if (node >= this.nodeProperties.array.length) {
            this.nodeProperties.ensureCapacity(this.size);
        }
        this.nodeProperties.array[node] = property;
    }

    @Override
    protected CompactEdge<EP> createEdge(int source, int target, @Nullable EP property) {
        return new CompactEdge<EP>(target, property);
    }

    @Override
    public NP getNodeProperties(int node) {
        if (node < this.nodeProperties.array.length) {
            return (NP)this.nodeProperties.array[node];
        }
        return null;
    }
}

