/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.random;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;

public class WeightedSupplier<T>
implements Supplier<T>,
Function<Random, T> {
    private static final Random RANDOM = new Random();
    private final List<SubSupplier<T>> subSuppliers = new ArrayList<SubSupplier<T>>();
    private int totalWeight;

    public WeightedSupplier<T> add(T obj, int weight) {
        return this.add(() -> obj, weight);
    }

    public WeightedSupplier<T> add(Supplier<? extends T> supplier, int weight) {
        if (weight < 0) {
            return this;
        }
        int low = this.totalWeight;
        this.totalWeight += weight;
        SubSupplier<? extends T> ss = new SubSupplier<T>(low, this.totalWeight, supplier);
        this.subSuppliers.add(ss);
        return this;
    }

    public Supplier<T> forRandom(Random r) {
        return () -> this.apply(r);
    }

    @Override
    public T apply(Random r) {
        int val = r.nextInt(this.totalWeight);
        int l = 0;
        int h2 = this.subSuppliers.size();
        while (l < h2) {
            int mid = l + (h2 - l) / 2;
            SubSupplier<T> ss = this.subSuppliers.get(mid);
            if (((SubSupplier)ss).lowIdx <= val) {
                if (((SubSupplier)ss).highIdx > val) {
                    return ss.get();
                }
                l = mid + 1;
                continue;
            }
            h2 = mid;
        }
        throw new AssertionError();
    }

    @Override
    public T get() {
        return this.apply(RANDOM);
    }

    private static final class SubSupplier<T>
    implements Supplier<T> {
        private final int lowIdx;
        private final int highIdx;
        private final Supplier<? extends T> supplier;

        SubSupplier(int lowIdx, int highIdx, Supplier<? extends T> supplier) {
            this.lowIdx = lowIdx;
            this.highIdx = highIdx;
            this.supplier = supplier;
        }

        @Override
        public T get() {
            return this.supplier.get();
        }
    }
}

