/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.lib;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformProperties {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformProperties.class);
    private static final String PLATFORM_ALIASES = "platform-aliases.properties";
    public static final String OS_NAME;
    public static final String OS_ARCH;
    public static final String OS_VERSION;

    private PlatformProperties() {
        throw new AssertionError();
    }

    static {
        Properties aliases = new Properties();
        try (InputStream is = PlatformProperties.class.getResourceAsStream("/platform-aliases.properties");){
            if (is == null) {
                LOG.warn("Could not find '{}'.", (Object)PLATFORM_ALIASES);
            } else {
                aliases.load(is);
            }
        }
        catch (IOException ex) {
            LOG.warn("Could not load platform aliases file.", ex);
            LOG.warn("You may experience issues with the resolution of native libraries.");
        }
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT).replace(' ', '_').replace('/', '_');
        OS_NAME = aliases.getProperty("os." + osName, osName);
        String osArch = System.getProperty("os.arch").toLowerCase(Locale.ROOT).replace(' ', '_').replace('/', '_');
        OS_ARCH = aliases.getProperty("arch." + osArch, osArch);
        OS_VERSION = System.getProperty("os.version");
    }
}

