/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.commons.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class AllCombinationsIterator<T>
implements Iterator<List<T>> {
    private final Iterable<? extends T>[] iterables;
    private final Iterator<? extends T>[] iterators;
    private final List<T> current;
    private boolean first = true;
    private boolean empty;

    @SafeVarargs
    AllCombinationsIterator(Iterable<? extends T> ... iterables) {
        this.iterables = iterables;
        this.iterators = new Iterator[iterables.length];
        this.current = new ArrayList<T>(iterables.length);
        for (int i = 0; i < this.iterators.length; ++i) {
            Iterator<T> it = iterables[i].iterator();
            if (!it.hasNext()) {
                this.empty = true;
                break;
            }
            this.iterators[i] = it;
            this.current.add(it.next());
        }
    }

    @Override
    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        for (Iterator<T> iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> next() {
        if (this.empty) {
            throw new NoSuchElementException();
        }
        if (this.first) {
            this.first = false;
            return this.current;
        }
        for (int i = 0; i < this.iterators.length; ++i) {
            Iterator<T> it = this.iterators[i];
            if (this.iterators[i].hasNext()) {
                this.current.set(i, it.next());
                return this.current;
            }
            it = this.iterables[i].iterator();
            this.iterators[i] = it;
            this.current.set(i, it.next());
        }
        throw new NoSuchElementException();
    }
}

