/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.blockmodel.VertexPartition;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VertexPartitionCollapser<V, E, CV, CE> {
    protected Supplier<Graph<CV, CE>> graph_factory;
    protected Supplier<CV> vertex_factory;
    protected Supplier<CE> edge_factory;
    protected Map<Set<V>, CV> set_collapsedv;

    public VertexPartitionCollapser(Supplier<Graph<CV, CE>> graph_factory, Supplier<CV> vertex_factory, Supplier<CE> edge_factory) {
        this.graph_factory = graph_factory;
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
        this.set_collapsedv = new HashMap<Set<V>, CV>();
    }

    public Graph<CV, CE> collapseVertexPartitions(VertexPartition<V, E> partitioning) {
        Graph<V, Set<Object>> original = partitioning.getGraph();
        Graph<CV, CE> collapsed = this.graph_factory.get();
        for (Set<V> set : partitioning.getVertexPartitions()) {
            CV cv = this.vertex_factory.get();
            collapsed.addVertex(this.vertex_factory.get());
            this.set_collapsedv.put(set, cv);
        }
        for (Set<Object> e : original.getEdges()) {
            Collection incident = original.getIncidentVertices(e);
            HashSet<CV> collapsed_vertices = new HashSet<CV>();
            Map<V, Set<V>> vertex_partitions = partitioning.getVertexToPartitionMap();
            for (Object v : incident) {
                collapsed_vertices.add(this.set_collapsedv.get(vertex_partitions.get(v)));
            }
            if (collapsed_vertices.size() <= 1) continue;
            CE ce = this.edge_factory.get();
            collapsed.addEdge(ce, collapsed_vertices);
        }
        return collapsed;
    }

    public Function<Set<V>, CV> getSetToCollapsedVertexTransformer() {
        return Functions.forMap(this.set_collapsedv);
    }
}

