/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;

public class DirectionTransformer {
    public static <V, E> UndirectedGraph<V, E> toUndirected(Graph<V, E> graph, Supplier<UndirectedGraph<V, E>> graph_factory, Supplier<E> edge_factory, boolean create_new) {
        UndirectedGraph<V, E> out = graph_factory.get();
        for (Object v : graph.getVertices()) {
            out.addVertex(v);
        }
        for (Object e : graph.getEdges()) {
            Pair<V> endpoints = graph.getEndpoints(e);
            V v1 = endpoints.getFirst();
            V v2 = endpoints.getSecond();
            Object to_add = graph.getEdgeType(e) == EdgeType.DIRECTED || create_new ? edge_factory.get() : e;
            out.addEdge(to_add, v1, v2, EdgeType.UNDIRECTED);
        }
        return out;
    }

    public static <V, E> Graph<V, E> toDirected(Graph<V, E> graph, Supplier<DirectedGraph<V, E>> graph_factory, Supplier<E> edge_factory, boolean create_new) {
        DirectedGraph<V, Object> out = graph_factory.get();
        for (Object v : graph.getVertices()) {
            out.addVertex(v);
        }
        for (Object e : graph.getEdges()) {
            Pair<V> endpoints = graph.getEndpoints(e);
            if (graph.getEdgeType(e) == EdgeType.UNDIRECTED) {
                V v1 = endpoints.getFirst();
                V v2 = endpoints.getSecond();
                out.addEdge(edge_factory.get(), v1, v2, EdgeType.DIRECTED);
                out.addEdge(edge_factory.get(), v2, v1, EdgeType.DIRECTED);
                continue;
            }
            V source = graph.getSource(e);
            V dest = graph.getDest(e);
            Object to_add = create_new ? edge_factory.get() : e;
            out.addEdge(to_add, source, dest, EdgeType.DIRECTED);
        }
        return out;
    }
}

