/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring.util;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.scoring.HITS;
import java.util.Collection;

public class ScoringUtils {
    public static <V> Function<V, Double> getUniformRootPrior(Collection<V> roots) {
        final Collection<V> inner_roots = roots;
        Function distribution = new Function<V, Double>(){

            @Override
            public Double apply(V input) {
                if (inner_roots.contains(input)) {
                    return new Double(1.0 / (double)inner_roots.size());
                }
                return 0.0;
            }
        };
        return distribution;
    }

    public static <V> Function<V, HITS.Scores> getHITSUniformRootPrior(Collection<V> roots) {
        final Collection<V> inner_roots = roots;
        Function distribution = new Function<V, HITS.Scores>(){

            @Override
            public HITS.Scores apply(V input) {
                if (inner_roots.contains(input)) {
                    return new HITS.Scores(1.0 / (double)inner_roots.size(), 1.0 / (double)inner_roots.size());
                }
                return new HITS.Scores(0.0, 0.0);
            }
        };
        return distribution;
    }
}

