/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.fa.figures.FADrawMode;
import de.renew.fa.figures.FigureDecoration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.io.IOException;

public class EndDecoration
implements FigureDecoration {
    private static final int DEFAULT_SIZE = 20;
    static final long serialVersionUID = 6389353696652739208L;
    protected int _halfSize;
    protected int _size;

    public static int getDefaultSize() {
        return 20;
    }

    @Override
    public void draw(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (FADrawMode.getInstance().getMode() == 0) {
            this.drawStandard(g, r, fillColor, lineColor);
        } else {
            this.drawAlternative(g, r, fillColor, lineColor);
        }
    }

    public void drawStandard(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (!ColorMap.isTransparent((Color)lineColor)) {
            g.setColor(lineColor);
            g.fillArc(r.x, r.y, r.width, r.height, 60, -120);
            if (!ColorMap.isTransparent((Color)fillColor)) {
                g.setColor(fillColor);
            } else {
                g.setColor(Color.WHITE);
            }
            g.fillRect(this.getXabs(r) + r.width / 4 + 1, this.getYabs(r) + 1, Double.valueOf(r.width / 2).intValue(), Double.valueOf(this.getYprime(r) * 2.0).intValue());
        }
    }

    public void drawAlternative(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (!ColorMap.isTransparent((Color)lineColor)) {
            Ellipse2D.Double s = new Ellipse2D.Double(r.x + 3, r.y + 3, r.width - 6, r.height - 6);
            ((Graphics2D)g).draw(s);
        }
    }

    @Override
    public boolean equals(FigureDecoration fd) {
        return fd instanceof EndDecoration;
    }

    private int getXabs(Rectangle r) {
        return r.x;
    }

    private int getYabs(Rectangle r) {
        float b = r.height / 2;
        return Double.valueOf((double)((float)r.y + b) - this.getYprime(r)).intValue();
    }

    private double getYprime(Rectangle r) {
        float b = r.height / 2;
        return Math.sqrt(0.75 * (double)b * (double)b);
    }

    public void read(StorableInput dr) throws IOException {
    }

    public void write(StorableOutput dw) {
    }
}

