/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.UndoableTool;
import de.renew.netcomponents.NetComponentFigure;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InsertionTool
extends UndoableTool {
    public static final Logger LOGGER = Logger.getLogger(InsertionTool.class);
    private Vector<Figure> _fv;
    private Vector<Figure> _selectedf;

    public InsertionTool(DrawingEditor editor, Vector<Figure> fv) {
        super(editor);
        this._fv = fv;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        this.insert(x, y);
    }

    public void insert(int x, int y) {
        try {
            Vector figures;
            Vector<Figure> v = this._fv;
            FigureSelection fs = new FigureSelection(v);
            this._selectedf = figures = fs.getData("CH.ifa.draw.Figures");
            this.view().addAll(figures);
            this.view().addToSelectionAll(figures);
            StandardDrawingView.moveFigures((Vector)figures, (int)x, (int)y);
            for (Figure figure : figures) {
                if (!(figure instanceof NetComponentFigure)) continue;
                NetComponentFigure ncfigure = (NetComponentFigure)figure;
                ncfigure.updateListeners();
            }
            this.view().checkDamage();
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.changesMade();
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.editor().toolDone();
        this.view().addToSelectionAll(this._selectedf);
    }
}

