/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.LinkedList;
import collections.Seq;
import collections.UpdatableMap;
import collections.UpdatableSeq;
import java.io.Serializable;

public class OrderedTable
implements Serializable {
    private UpdatableMap _table;
    private UpdatableSeq _keys;
    private UpdatableSeq _orderSource;

    public OrderedTable() {
        this(null);
    }

    public OrderedTable(CollectionEnumeration orderEnum) {
        if (orderEnum == null) {
            this._orderSource = null;
        } else {
            this._orderSource = new LinkedList();
            while (orderEnum.hasMoreElements()) {
                this._orderSource.insertLast(orderEnum.nextElement());
            }
        }
        this._table = new HashedMap();
        this._keys = new LinkedList();
    }

    private OrderedTable(UpdatableMap table, UpdatableSeq keys, UpdatableSeq orderSource) {
        this._table = (UpdatableMap)table.duplicate();
        this._keys = (UpdatableSeq)keys.duplicate();
        this._orderSource = orderSource;
    }

    public void putAt(Object key, Object value) {
        if (!this._keys.includes(key)) {
            if (this._orderSource == null) {
                this._keys.insertLast(key);
            } else {
                int index = 0;
                boolean found = false;
                for (int i = 0; i < this._orderSource.size(); ++i) {
                    Object currkey = this._orderSource.at(i);
                    if (key.equals(currkey)) {
                        found = true;
                        break;
                    }
                    if (index >= this._keys.size() || !this._keys.at(index).equals(currkey)) continue;
                    ++index;
                }
                if (found) {
                    this._keys.insertAt(index, key);
                } else {
                    this._keys.insertLast(key);
                }
            }
        }
        this._table.putAt(key, value);
    }

    public void insertAt(Object key, int index, Object value) {
        this._keys.removeOneOf(key);
        this._keys.insertAt(index, key);
        this._table.putAt(key, value);
    }

    public void removeAt(Object key) {
        this._keys.removeOneOf(key);
        this._table.removeAt(key);
    }

    public boolean includesKey(Object key) {
        return this._keys.includes(key);
    }

    public boolean includes(Object element) {
        return this._table.includes(element);
    }

    public int size() {
        return this._keys.size();
    }

    public CollectionEnumeration keys() {
        return ((Seq)this._keys.duplicate()).elements();
    }

    public Object at(Object key) {
        return this._table.at(key);
    }

    public boolean isEmpty() {
        return this._keys.isEmpty();
    }

    public Object duplicate() {
        return new OrderedTable(this._table, this._keys, this._orderSource);
    }
}

