/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.HashedSet;
import collections.Set;
import collections.UpdatableMap;
import collections.UpdatableSet;
import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.EmptyEnumeration;
import de.uni_hamburg.fs.Equality;
import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.Feature;
import de.uni_hamburg.fs.JavaArrayType;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.JavaType;
import de.uni_hamburg.fs.ListType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.NotInstantiableException;
import de.uni_hamburg.fs.Path;
import de.uni_hamburg.fs.PrettyPrinter;
import de.uni_hamburg.fs.Subsumption;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.UnificationFailure;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FeatureStructure
implements Serializable {
    public static final Logger LOGGER = Logger.getLogger(FeatureStructure.class);
    private Node _node;
    protected int _hashCode;

    public FeatureStructure(Node node) {
        this(node, true);
    }

    public FeatureStructure(Node node, boolean mayNeedReduction) {
        this._node = node;
        if (mayNeedReduction) {
            this.reduce();
        }
        this.computeHashCode(node, (UpdatableSet)new HashedSet());
    }

    public FeatureStructure(Type type) {
        this(type.newNode(), false);
    }

    private void computeHashCode(Node node, UpdatableSet visited) {
        if (!visited.includes((Object)node)) {
            visited.include((Object)node);
            Type type = node.getType();
            this._hashCode += type.hashCode();
            if (!(type instanceof JavaObject)) {
                CollectionEnumeration featenumeration = node.featureNames();
                while (featenumeration.hasMoreElements()) {
                    Name feature = (Name)featenumeration.nextElement();
                    this._hashCode += feature.hashCode();
                    this.computeHashCode(node.delta(feature), visited);
                }
            }
        }
    }

    public Type getType() {
        return this._node.getType();
    }

    public Type getType(String path) throws NoSuchFeatureException {
        return this._node.delta(new Path(path)).getType();
    }

    public Node getRoot() {
        return this._node;
    }

    public Object getJavaObject() {
        return ((JavaType)this._node.getType()).getJavaObject();
    }

    public boolean subsumes(FeatureStructure that) {
        return Subsumption.subsumes(this, that);
    }

    public boolean subsumedBy(FeatureStructure that) {
        return that.subsumes(this);
    }

    public FeatureStructure unify(FeatureStructure that) throws UnificationFailure {
        return new FeatureStructure(EquivRelation.unify(this, that));
    }

    public FeatureStructure unify(FeatureStructure that, String path) throws UnificationFailure {
        return this.unify(that, new Path(path));
    }

    public FeatureStructure unify(FeatureStructure that, Path path) throws UnificationFailure {
        return new FeatureStructure(EquivRelation.unify(this, path, that));
    }

    public FeatureStructure equate(String path1, String path2) throws UnificationFailure {
        return this.equate(new Path(path1), new Path(path2));
    }

    public FeatureStructure equate(Path path1, Path path2) throws UnificationFailure {
        return new FeatureStructure(EquivRelation.unify(this, path1, path2));
    }

    public boolean canUnify(FeatureStructure that) {
        return EquivRelation.canUnify(this, that);
    }

    public CollectionEnumeration featureNames() {
        return this._node.featureNames();
    }

    public boolean hasFeature(String feature) {
        return this._node.hasFeature(new Name(feature));
    }

    public boolean hasFeature(Name featureName) {
        return this._node.hasFeature(featureName);
    }

    public FeatureStructure at(String path) throws NoSuchFeatureException {
        return this.at(new Path(path));
    }

    public FeatureStructure at(Path path) throws NoSuchFeatureException {
        return new FeatureStructure(this.delta(path), true);
    }

    public Object unpackingAt(Path path) throws NoSuchFeatureException {
        Node subnode = this._node.delta(path);
        Type subtype = subnode.getType();
        if (subtype instanceof JavaType) {
            return ((JavaType)subtype).getJavaObject();
        }
        return new FeatureStructure(subnode, true);
    }

    public Node delta(String path) throws NoSuchFeatureException {
        return this.delta(new Path(path));
    }

    public Node delta(Name feature) throws NoSuchFeatureException {
        return this._node.delta(feature);
    }

    public Node delta(Path path) throws NoSuchFeatureException {
        return this._node.delta(path);
    }

    public boolean canInstantiate() {
        int countToBeInstantiated;
        boolean canInstantiate;
        HashedSet toBeInstantiated = new HashedSet();
        do {
            countToBeInstantiated = toBeInstantiated.size();
        } while (!(canInstantiate = FeatureStructure.canInstantiate(this._node, (UpdatableSet)new HashedSet(), (UpdatableSet)toBeInstantiated)) && toBeInstantiated.size() > countToBeInstantiated);
        return canInstantiate;
    }

    private static boolean canInstantiate(Node node, UpdatableSet visited, UpdatableSet toBeInstantiated) {
        boolean include;
        Type typ;
        block6: {
            JavaConcept onlyConcept;
            block7: {
                ListType listType;
                block8: {
                    if (FeatureStructure.isInstantiated(node, (Set)toBeInstantiated)) {
                        return true;
                    }
                    typ = node.getType();
                    if (visited.includes((Object)node)) {
                        return !typ.isInstanceType();
                    }
                    visited.include((Object)node);
                    include = false;
                    if (!typ.isInstanceType()) break block6;
                    if (!(typ instanceof ListType)) break block7;
                    listType = (ListType)typ;
                    if (listType.getSubtype() != 2) break block8;
                    include = true;
                    break block6;
                }
                if (listType.getSubtype() != 1) break block6;
                include = FeatureStructure.isInstantiated(node.delta(ListType.HEAD), (Set)toBeInstantiated) && FeatureStructure.isInstantiated(node.delta(ListType.TAIL), (Set)toBeInstantiated);
                break block6;
            }
            if (typ instanceof ConjunctiveType && (onlyConcept = ((ConjunctiveType)typ).getOnlyInstantiableJavaConcept()) != null) {
                JavaConcept javaConcept = onlyConcept;
                CollectionEnumeration feats = node.featureNames();
                include = true;
                while (feats.hasMoreElements()) {
                    Name feature = (Name)feats.nextElement();
                    if (javaConcept.getJavaFeature(feature).canSet() && FeatureStructure.isInstantiated(node.delta(feature), (Set)toBeInstantiated)) continue;
                    include = false;
                    break;
                }
            }
        }
        if (include) {
            toBeInstantiated.include((Object)node);
        }
        boolean canInstantiate = include || !typ.isInstanceType();
        CollectionEnumeration feats = node.featureNames();
        while (feats.hasMoreElements()) {
            Name feature = (Name)feats.nextElement();
            canInstantiate &= FeatureStructure.canInstantiate(node.delta(feature), visited, toBeInstantiated);
        }
        return canInstantiate;
    }

    private static boolean isInstantiated(Node node, Set toBeInstantiated) {
        if (toBeInstantiated.includes((Object)node)) {
            return true;
        }
        Type typ = node.getType();
        return typ instanceof JavaType || typ instanceof BasicType && ((BasicType)typ).isObject();
    }

    public FeatureStructure instantiate() throws NotInstantiableException {
        HashedSet toBeInstantiated = new HashedSet();
        if (FeatureStructure.canInstantiate(this._node, (UpdatableSet)new HashedSet(), (UpdatableSet)toBeInstantiated) && toBeInstantiated.size() == 0) {
            return this;
        }
        return new FeatureStructure(FeatureStructure.instantiate(this._node, (UpdatableMap)new HashedMap()), false);
    }

    private static Node instantiate(Node node, UpdatableMap objMap) throws NotInstantiableException {
        if (objMap.includesKey((Object)node)) {
            return (Node)objMap.at((Object)node);
        }
        Type typ = node.getType();
        Node newNode = null;
        boolean mapFeatures = true;
        if (typ.isInstanceType()) {
            if (typ instanceof JavaType) {
                newNode = node;
                mapFeatures = false;
            } else if (typ instanceof ListType) {
                Vector<Object> elements = new Vector<Object>();
                for (Node current = node; current != null && ((ListType)current.getType()).getSubtype() == 1; current = current.delta(ListType.TAIL)) {
                    Node objNode = FeatureStructure.instantiate(current.delta(ListType.HEAD), objMap);
                    elements.addElement(((JavaType)objNode.getType()).getJavaObject());
                }
                Object[] elemArray = new Object[elements.size()];
                elements.copyInto(elemArray);
                Object array = JavaArrayType.makeArray(elemArray);
                newNode = new JavaArrayType(array).newNode();
                mapFeatures = false;
            } else {
                try {
                    JavaConcept javaConcept = (JavaConcept)((ConjunctiveType)typ)._concepts.elements().nextConcept();
                    Object object = javaConcept.getJavaClass().newInstance();
                    newNode = new JavaObject(object);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Cannot instantiate: " + String.valueOf(e)));
                    throw new NotInstantiableException(new FeatureStructure(node, false));
                }
            }
        } else {
            newNode = typ.newNode();
        }
        objMap.putAt((Object)node, (Object)newNode);
        if (mapFeatures) {
            CollectionEnumeration feats = node.featureNames();
            while (feats.hasMoreElements()) {
                Name feature = (Name)feats.nextElement();
                newNode.setFeature(feature, FeatureStructure.instantiate(node.delta(feature), objMap));
            }
        }
        return newNode;
    }

    public FeatureStructure change(String feature, FeatureStructure newValue) {
        Name featureName = new Name(feature);
        FSNode newNode = (FSNode)this._node.duplicate();
        newNode.setFeature(featureName, newValue._node);
        return new FeatureStructure(newNode);
    }

    public Enumeration<Node> getNodes() {
        return FeatureStructure.addNodes((UpdatableSet)new HashedSet(), this._node).elements();
    }

    private static UpdatableSet addNodes(UpdatableSet nodes, Node fs) {
        if (!(fs instanceof JavaObject) && !nodes.includes((Object)fs)) {
            nodes.include((Object)fs);
            CollectionEnumeration featenumeration = fs.featureNames();
            while (featenumeration.hasMoreElements()) {
                Name feature = (Name)featenumeration.nextElement();
                FeatureStructure.addNodes(nodes, fs.delta(feature));
            }
        }
        return nodes;
    }

    public Path onePathTo(Node target) {
        return FeatureStructure.onePathTo((UpdatableSet)new HashedSet(), this._node, Path.EPSILON, target);
    }

    private static Path onePathTo(UpdatableSet nodes, Node fs, Path path, Node target) {
        if (fs.equals(target)) {
            return path;
        }
        if (!nodes.includes((Object)fs)) {
            nodes.include((Object)fs);
            CollectionEnumeration featenumeration = fs.featureNames();
            while (featenumeration.hasMoreElements()) {
                Name feature = (Name)featenumeration.nextElement();
                Path found = FeatureStructure.onePathTo(nodes, fs.delta(feature), path.append(feature), target);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public Enumeration<Node> backwardsReachableNodes(Node target) {
        HashedMap map = new HashedMap();
        HashedMap pam = new HashedMap();
        this.reverse(this._node, (UpdatableSet)new HashedSet(), 0, (UpdatableMap)map, (UpdatableMap)pam);
        if (!map.includesKey((Object)target)) {
            return EmptyEnumeration.INSTANCE;
        }
        Node newRoot = (Node)map.at((Object)target);
        FeatureStructure reverseFS = new FeatureStructure(newRoot, false);
        Enumeration<Node> reachenumeration = reverseFS.getNodes();
        HashedSet backwardsReachableNodes = new HashedSet();
        while (reachenumeration.hasMoreElements()) {
            Node bnode = (Node)pam.at((Object)reachenumeration.nextElement());
            backwardsReachableNodes.include((Object)bnode);
        }
        return backwardsReachableNodes.elements();
    }

    private static Node getReverse(UpdatableMap map, UpdatableMap pam, Node fs) {
        Node rev;
        if (map.includesKey((Object)fs)) {
            rev = (Node)map.at((Object)fs);
        } else {
            rev = Type.ANY.newNode();
            map.putAt((Object)fs, (Object)rev);
            pam.putAt((Object)rev, (Object)fs);
        }
        return rev;
    }

    private int reverse(Node fs, UpdatableSet visited, int featureCnt, UpdatableMap map, UpdatableMap pam) {
        if (visited.includes((Object)fs) || fs instanceof JavaObject) {
            return featureCnt;
        }
        visited.include((Object)fs);
        Node fsRev = FeatureStructure.getReverse(map, pam, fs);
        CollectionEnumeration featenumeration = fs.featureNames();
        while (featenumeration.hasMoreElements()) {
            Name feature = (Name)featenumeration.nextElement();
            Node next = fs.delta(feature);
            Node nextRev = FeatureStructure.getReverse(map, pam, next);
            nextRev.setFeature(new Name("f" + featureCnt), fsRev);
            ++featureCnt;
            featureCnt = this.reverse(next, visited, featureCnt, map, pam);
        }
        return featureCnt;
    }

    public void reduce() {
        int lastNoInfoNodes;
        HashedSet infoNodes = new HashedSet();
        infoNodes.include((Object)this._node);
        int noInfoNodes = 1;
        do {
            HashedSet allNodes = new HashedSet();
            lastNoInfoNodes = noInfoNodes;
            FeatureStructure.findInfo(this._node, (UpdatableSet)allNodes, (UpdatableSet)infoNodes);
            noInfoNodes = infoNodes.size();
            if (noInfoNodes != allNodes.size()) continue;
            return;
        } while (noInfoNodes > lastNoInfoNodes);
        this._node = FeatureStructure.copyInfoNodes(this._node, (UpdatableMap)new HashedMap(), (Set)infoNodes);
    }

    private static void findInfo(Node fs, UpdatableSet visited, UpdatableSet infoNodes) {
        if (visited.includes((Object)fs)) {
            infoNodes.include((Object)fs);
        } else {
            visited.include((Object)fs);
            if (fs instanceof JavaObject) {
                infoNodes.include((Object)fs);
            } else {
                CollectionEnumeration featenumeration = fs.featureNames();
                Type fstype = fs.getType();
                boolean hasInfo = infoNodes.includes((Object)fs);
                while (featenumeration.hasMoreElements()) {
                    Name feature = (Name)featenumeration.nextElement();
                    Node next = fs.delta(feature);
                    boolean nextHasInfo = infoNodes.includes((Object)next);
                    if (!nextHasInfo && !next.getType().equals(fstype.appropType(feature))) {
                        infoNodes.include((Object)next);
                        nextHasInfo = true;
                    }
                    if (!hasInfo && nextHasInfo) {
                        infoNodes.include((Object)fs);
                        hasInfo = true;
                    }
                    FeatureStructure.findInfo(next, visited, infoNodes);
                }
            }
        }
    }

    private static Node copyInfoNodes(Node fs, UpdatableMap map, Set infoNodes) {
        if (fs instanceof JavaObject) {
            return fs;
        }
        if (map.includesKey((Object)fs)) {
            return (Node)map.at((Object)fs);
        }
        Node copy = fs.duplicate();
        map.putAt((Object)fs, (Object)copy);
        CollectionEnumeration featenumeration = fs.featureNames();
        while (featenumeration.hasMoreElements()) {
            Name feature = (Name)featenumeration.nextElement();
            Node next = copy.delta(feature);
            if (infoNodes.includes((Object)next)) {
                copy.setFeature(feature, FeatureStructure.copyInfoNodes(next, map, infoNodes));
                continue;
            }
            copy.setFeature(feature, null);
        }
        return copy;
    }

    public Feature getFirstMissingAssociation() {
        Type type = this._node.getType();
        CollectionEnumeration feats = type.appropFeatureNames();
        JavaConcept jc = null;
        if (type instanceof ConjunctiveType) {
            jc = ((ConjunctiveType)type).getOnlyInstantiableJavaConcept();
        }
        while (feats.hasMoreElements()) {
            Type approp;
            Name feature = (Name)feats.nextElement();
            if (this._node.hasFeature(feature) || (approp = type.appropType(feature)) instanceof BasicType || jc != null && !jc.getJavaFeature(feature).canSet()) continue;
            return new Feature(feature, approp);
        }
        return null;
    }

    public boolean equals(Object that) {
        if (that instanceof FeatureStructure) {
            return Equality.equals(this, (FeatureStructure)that);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String toString() {
        return PrettyPrinter.toString(this);
    }
}

