/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.Map;
import de.uni_hamburg.fs.AbstractNode;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.UnificationFailure;

public class FSNode
extends AbstractNode {
    private static final boolean DEBUG = false;
    OrderedTable _feats;

    public FSNode(Type nodetype, Map feats) {
        super(nodetype);
        this._feats = new OrderedTable(nodetype.appropFeatureNames());
        CollectionEnumeration features = feats.keys();
        while (features.hasMoreElements()) {
            Name feature = (Name)features.nextElement();
            this.setFeature(feature, (Node)feats.at((Object)feature));
        }
    }

    public FSNode(Type nodetype) {
        super(nodetype);
        this._feats = new OrderedTable(nodetype.appropFeatureNames());
    }

    public FSNode() {
        this(Type.ANY);
    }

    public FSNode(String nodetype) throws UnificationFailure {
        this(ConjunctiveType.getType(nodetype));
    }

    public FSNode(String nodetype, OrderedTable feats) throws UnificationFailure, TypeException {
        this(ConjunctiveType.getType(nodetype), feats);
    }

    FSNode(Type nodetype, OrderedTable feats) {
        super(nodetype);
        this._feats = feats;
    }

    @Override
    public CollectionEnumeration featureNames() {
        return this._feats.keys();
    }

    @Override
    public boolean hasFeature(Name featureName) {
        return this._feats.includesKey(featureName);
    }

    @Override
    public Node delta(Name featureName) throws NoSuchFeatureException {
        if (this._feats.includesKey(featureName)) {
            return (Node)this._feats.at(featureName);
        }
        if (this._nodetype.isApprop(featureName)) {
            return this._nodetype.appropType(featureName).newNode();
        }
        throw new NoSuchFeatureException(featureName, this._nodetype);
    }

    @Override
    public void setFeature(Name featureName, Node value) {
        if (value == null) {
            this._feats.removeAt(featureName);
        } else {
            this._feats.putAt(featureName, value);
        }
    }

    @Override
    public Node duplicate() {
        return new FSNode(this._nodetype, (OrderedTable)this._feats.duplicate());
    }
}

