/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.Set;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptEnumeration;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.JavaClassType;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoFeatureNode;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.NullObject;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ConjunctiveType
implements Type {
    public static final Logger LOGGER = Logger.getLogger(ConjunctiveType.class);
    ConceptSet _concepts = new ConceptSet();
    private OrderedTable _features = new OrderedTable();
    private boolean _extensional = false;
    private boolean _printAny = true;
    private boolean _restricted = true;
    private boolean _isJavaConceptType = false;
    private boolean _toBeInstantiated = false;

    public ConjunctiveType(boolean restricted) {
        this._restricted = restricted;
    }

    public ConjunctiveType(boolean restricted, boolean printAny) {
        this(restricted);
        this._printAny = printAny;
    }

    public ConjunctiveType(Concept concept) {
        try {
            this.addConcept(concept);
        }
        catch (UnificationFailure uff) {
            throw new RuntimeException("***Unexpected failure in addConcept(" + String.valueOf(concept) + ").");
        }
    }

    public ConjunctiveType(Concept concept, boolean isRestricted) throws UnificationFailure {
        this(isRestricted);
        this.addConcept(concept);
    }

    public ConjunctiveType(ConceptSet concepts) throws UnificationFailure {
        this(concepts, true);
    }

    public ConjunctiveType(ConceptSet concepts, boolean isRestricted, boolean printAny) throws UnificationFailure {
        this(concepts, isRestricted, printAny, false);
    }

    public ConjunctiveType(ConceptSet concepts, boolean isRestricted, boolean printAny, boolean toBeInstantiated) throws UnificationFailure {
        this(isRestricted);
        this._printAny = printAny;
        this._toBeInstantiated = toBeInstantiated;
        ConceptEnumeration conceptEnum = concepts.elements();
        while (conceptEnum.hasMoreElements()) {
            this.addConcept(conceptEnum.nextConcept());
        }
    }

    public ConjunctiveType(ConceptSet concepts, boolean isRestricted) throws UnificationFailure {
        this(concepts, isRestricted, true);
    }

    public int hashCode() {
        return this._concepts.hashCode() + (this._restricted ? 3 : 0) + (this._toBeInstantiated ? 5 : 0);
    }

    public ConceptEnumeration concepts() {
        return this._concepts.elements();
    }

    @Override
    public String getName() {
        if (this._restricted && this._toBeInstantiated && this._concepts.isEmpty()) {
            return " ";
        }
        return ConjunctiveType.typeToString(this._restricted, this._printAny, false, this._concepts);
    }

    @Override
    public String getFullName() {
        return ConjunctiveType.typeToString(this._restricted, this._printAny, true, this._concepts);
    }

    static String typeToString(boolean restricted, boolean printAny, boolean qualified, ConceptSet concepts) {
        StringBuffer output = new StringBuffer();
        if (!restricted && printAny) {
            output.append("Any");
        }
        ConceptEnumeration conceptEnum = concepts.elements();
        while (conceptEnum.hasMoreElements()) {
            if (output.length() > 0) {
                output.append(',');
            }
            Concept concept = (Concept)conceptEnum.nextElement();
            if (qualified) {
                output.append(concept.getFullName());
                continue;
            }
            output.append(concept.getName());
        }
        return output.toString();
    }

    public static Type getType(Set concepts) throws UnificationFailure {
        if (concepts.isEmpty()) {
            return Type.TOP;
        }
        CollectionEnumeration conceptEnum = concepts.elements();
        ConjunctiveType newtype = new ConjunctiveType(true);
        while (conceptEnum.hasMoreElements()) {
            newtype.addConcept((Concept)conceptEnum.nextElement());
        }
        return newtype;
    }

    public static Type getType(String conceptsStr) throws UnificationFailure, TypeException {
        StringTokenizer conceptNames = new StringTokenizer(conceptsStr, ",");
        HashedSet concepts = new HashedSet();
        TypeSystem ts = TypeSystem.instance();
        while (conceptNames.hasMoreElements()) {
            try {
                concepts.include((Object)ts.conceptForName(conceptNames.nextToken()));
            }
            catch (NoSuchElementException e) {
                throw new TypeException();
            }
        }
        return ConjunctiveType.getType((Set)concepts);
    }

    @Override
    public boolean isExtensional() {
        return this._extensional;
    }

    @Override
    public boolean isInstanceType() {
        return this._toBeInstantiated;
    }

    @Override
    public Type getInstanceType() {
        if (this.isInstanceType()) {
            return this;
        }
        ConjunctiveType instType = this.duplicate();
        instType._toBeInstantiated = true;
        return instType;
    }

    @Override
    public boolean isApprop(Name featureName) {
        if (this._restricted) {
            return this._features.includesKey(featureName);
        }
        return true;
    }

    @Override
    public Type appropType(Name featureName) {
        try {
            Type appropType;
            if (this._restricted || this._features.includesKey(featureName)) {
                ParsedType pt = (ParsedType)this._features.at(featureName);
                appropType = pt.asType();
                if (this._toBeInstantiated) {
                    appropType = appropType.getInstanceType();
                }
            } else {
                appropType = Type.TOP;
            }
            return appropType;
        }
        catch (UnificationFailure uff) {
            throw new RuntimeException("Conjunctive type for ConceptSet " + String.valueOf(this._features.at(featureName)) + " not defined!", uff);
        }
    }

    @Override
    public CollectionEnumeration appropFeatureNames() {
        return this._features.keys();
    }

    @Override
    public boolean subsumes(Type that) {
        if (this.equals(Type.TOP)) {
            return true;
        }
        if (that instanceof ConjunctiveType) {
            ConjunctiveType thatCT = (ConjunctiveType)that;
            if (!this._restricted && thatCT._restricted) {
                return false;
            }
            if (this._toBeInstantiated && !thatCT._toBeInstantiated) {
                return false;
            }
            ConceptEnumeration conceptEnum = this._concepts.elements();
            block0: while (conceptEnum.hasMoreElements()) {
                Concept concept = (Concept)conceptEnum.nextElement();
                ConceptEnumeration thatConceptEnum = thatCT.concepts();
                while (thatConceptEnum.hasMoreElements()) {
                    Concept thatConcept = (Concept)thatConceptEnum.nextElement();
                    if (!thatConcept.isa(concept)) continue;
                    continue block0;
                }
                return false;
            }
            return true;
        }
        if (this._restricted && (this._concepts.isEmpty() || this._isJavaConceptType)) {
            if (that instanceof JavaClassType) {
                JavaConcept jc = TypeSystem.instance().getJavaConcept(((JavaClassType)that).getJavaClass());
                ConceptEnumeration conceptEnum = this._concepts.elements();
                while (conceptEnum.hasMoreElements()) {
                    Concept concept = (Concept)conceptEnum.nextElement();
                    if (jc.isa(concept)) continue;
                    return false;
                }
                return true;
            }
            if (that instanceof NullObject) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canUnify(Type that) {
        try {
            this.unify(that);
            return true;
        }
        catch (UnificationFailure uff) {
            return false;
        }
    }

    private void basicAddConcept(Concept newConcept) throws UnificationFailure {
        CollectionEnumeration featenumeration = newConcept.appropFeatureNames();
        while (featenumeration.hasMoreElements()) {
            Name feature = (Name)featenumeration.nextElement();
            ParsedType newType = newConcept.appropParsedType(feature);
            if (this._features.includesKey(feature) && (newType = newType.unite((ParsedType)this._features.at(feature))) == null) {
                throw new UnificationFailure();
            }
            this._features.putAt(feature, newType);
        }
        this._extensional = this._extensional || newConcept.isExtensional();
    }

    public void addConcept(Concept newConcept) throws UnificationFailure {
        if (newConcept instanceof JavaConcept && ((JavaConcept)newConcept).getJavaClass().equals(String.class)) {
            throw new RuntimeException("String wrapped in ConjunctiveType!");
        }
        boolean newIsJavaConcept = newConcept instanceof JavaConcept;
        if (this._printAny) {
            if (this._concepts.isEmpty()) {
                if (!this._restricted && newIsJavaConcept) {
                    throw new UnificationFailure();
                }
                this._isJavaConceptType = newIsJavaConcept;
            } else if (this._isJavaConceptType != newIsJavaConcept) {
                throw new UnificationFailure();
            }
        }
        this._concepts.joinConcept(newConcept);
        this.basicAddConcept(newConcept);
    }

    private ConjunctiveType duplicate() {
        ConjunctiveType typ = new ConjunctiveType(this._restricted);
        typ._concepts = new ConceptSet(this._concepts);
        typ._features = (OrderedTable)this._features.duplicate();
        typ._extensional = this._extensional;
        typ._printAny = this._printAny;
        typ._toBeInstantiated = this._toBeInstantiated;
        typ._isJavaConceptType = this._isJavaConceptType;
        return typ;
    }

    @Override
    public Type unify(Type that) throws UnificationFailure {
        if (this.subsumes(that)) {
            return that;
        }
        if (that.subsumes(this)) {
            return this;
        }
        if (that instanceof ConjunctiveType) {
            ConjunctiveType typ = this.duplicate();
            ConjunctiveType thatCT = (ConjunctiveType)that;
            boolean bl = typ._restricted = typ._restricted && thatCT._restricted;
            if (!this._concepts.isEmpty() && !thatCT._concepts.isEmpty() && this._isJavaConceptType != thatCT._isJavaConceptType) {
                throw new UnificationFailure();
            }
            boolean bl2 = typ._isJavaConceptType = this._isJavaConceptType || thatCT._isJavaConceptType;
            if (typ._isJavaConceptType && !typ._restricted) {
                throw new UnificationFailure();
            }
            typ._toBeInstantiated = typ._toBeInstantiated || thatCT._toBeInstantiated;
            ConceptEnumeration thatConceptEnum = thatCT.concepts();
            while (thatConceptEnum.hasMoreElements()) {
                Concept thatConcept = (Concept)thatConceptEnum.nextElement();
                typ.addConcept(thatConcept);
            }
            return typ;
        }
        throw new UnificationFailure();
    }

    @Override
    public Type mostGeneralExtensionalSupertype(Type that) {
        return null;
    }

    @Override
    public Node newNode() {
        if (this._restricted && this._features.isEmpty()) {
            return new NoFeatureNode(this);
        }
        return new FSNode(this);
    }

    public String toString() {
        String name = this.getName();
        if (name.length() == 0) {
            return "Top";
        }
        return name;
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof ConjunctiveType) {
            ConjunctiveType thatType = (ConjunctiveType)that;
            return this._restricted == thatType._restricted && this._toBeInstantiated == thatType._toBeInstantiated && this._isJavaConceptType == thatType._isJavaConceptType && this._concepts.equals(thatType._concepts);
        }
        return false;
    }

    JavaConcept getOnlyInstantiableJavaConcept() {
        Concept onlyConcept;
        if (this._isJavaConceptType && this._concepts.size() == 1 && ((JavaConcept)(onlyConcept = this._concepts.elements().nextConcept())).canInstantiate()) {
            return (JavaConcept)onlyConcept;
        }
        return null;
    }
}

