/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptEnumeration;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.CyclicHierarchyException;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConceptImpl
implements Concept {
    public static final Logger LOGGER = Logger.getLogger(ConceptImpl.class);
    private String _name = null;
    private boolean _newExtensional = false;
    private boolean _extensional = false;
    private UpdatableSet _subsumes;
    private UpdatableSet _subsumedBy;
    protected ConceptSet _directSubs = new ConceptSet();
    protected ConceptSet _directSupers = new ConceptSet();
    private OrderedTable _newApprop = new OrderedTable();
    private OrderedTable _approp = new OrderedTable();
    private boolean _isDummy = false;
    Set<Object> _partitions = new HashSet<Object>();

    ConceptImpl() {
        this._name = "";
        this.transitiveClosure();
    }

    public ConceptImpl(String name, ConceptImpl[] directSuperList) throws TypeException {
        this(name);
        for (int i = 0; i < directSuperList.length; ++i) {
            this.addIsa(directSuperList[i]);
        }
    }

    public ConceptImpl(String name, ConceptImpl superConcept) throws TypeException {
        this(name, new ConceptImpl[]{superConcept});
    }

    public ConceptImpl(String name, boolean extensional, boolean isDummy) {
        this._extensional = extensional;
        this._isDummy = isDummy;
        this._subsumes = new HashedSet();
        this._subsumes.include((Object)this);
        if (!this.setName(name)) {
            throw new RuntimeException("Concept " + name + " already exists!");
        }
        TypeSystem.instance().transitiveClosure();
    }

    public ConceptImpl(String name, boolean extensional) {
        this(name, extensional, false);
    }

    public ConceptImpl(String name) {
        this(name, true);
    }

    @Override
    public String getName() {
        int end = this._name.indexOf("::");
        if (end == -1) {
            return this._name;
        }
        return this._name.substring(end + 2);
    }

    @Override
    public String getNamespace() {
        int end = this._name.indexOf("::");
        if (end == -1) {
            return "";
        }
        return this._name.substring(0, end);
    }

    @Override
    public String getFullName() {
        return this._name;
    }

    public boolean setName(String newname) {
        if (newname == null || newname.length() == 0) {
            return true;
        }
        if (newname.equals(this._name)) {
            return true;
        }
        TypeSystem ts = TypeSystem.instance();
        if (ts.hasConcept(newname)) {
            LOGGER.error((Object)("Concept " + newname + " already exists!"));
            return false;
        }
        if (this._name != null) {
            ts.removeConcept(this);
            LOGGER.debug((Object)("Renaming concept " + this._name + " to " + newname));
        } else {
            LOGGER.debug((Object)("Adding concept " + newname + " to  type system."));
        }
        this._name = newname;
        ts.addConcept(this);
        return true;
    }

    public boolean isDummy() {
        return this._isDummy;
    }

    @Override
    public boolean isExtensional() {
        return this._extensional;
    }

    @Override
    public boolean isApprop(Name feature) {
        if (this._approp == null) {
            LOGGER.debug((Object)("Approp is null in " + this._name + " (" + this.hashCode() + ") !!!"));
        }
        return this._approp.includesKey(feature);
    }

    @Override
    public ParsedType appropParsedType(Name featureName) throws NoSuchFeatureException {
        return (ParsedType)this._approp.at(featureName);
    }

    @Override
    public Type appropType(Name featureName) throws NoSuchFeatureException {
        try {
            return this.appropParsedType(featureName).asType();
        }
        catch (UnificationFailure uff) {
            throw new RuntimeException("The ConjunctiveType " + String.valueOf(this.appropParsedType(featureName)) + " is not defined!");
        }
    }

    @Override
    public CollectionEnumeration appropFeatureNames() {
        return this._approp.keys();
    }

    void inherit(UpdatableSet visited) throws UnificationFailure {
        visited.include((Object)this);
        ConceptEnumeration subenumeration = this._directSubs.elements();
        while (subenumeration.hasMoreElements()) {
            ConceptImpl sub = (ConceptImpl)subenumeration.nextConcept();
            if (this._extensional) {
                if (!sub._extensional) {
                    sub._extensional = true;
                    sub._subsumedBy = new HashedSet();
                    sub._subsumedBy.include((Object)sub);
                }
                sub._subsumedBy.include((Object)this);
            }
            boolean subchanged = false;
            int subcount = 0;
            CollectionEnumeration appropenumeration = this._approp.keys();
            while (appropenumeration.hasMoreElements()) {
                Name featureName = (Name)appropenumeration.nextElement();
                ParsedType appropType = this.appropParsedType(featureName);
                if (sub.isApprop(featureName)) {
                    LOGGER.debug((Object)("Overwriting feature in subconcept " + sub.getName()));
                    ParsedType oldsubapprop = (ParsedType)sub._approp.at(featureName);
                    ParsedType subapprop = oldsubapprop.unite(appropType);
                    if (subchanged || oldsubapprop.equals(subapprop)) continue;
                    subchanged = true;
                    continue;
                }
                sub._approp.insertAt(featureName, subcount++, appropType);
                subchanged = true;
            }
            if (!subchanged && visited.includes((Object)sub)) continue;
            sub.inherit(visited);
        }
    }

    protected void transitiveClosure() {
        this._subsumes = new HashedSet();
        this._subsumes.include((Object)this);
        ConceptEnumeration subenumeration = this._directSubs.elements();
        while (subenumeration.hasMoreElements()) {
            ConceptImpl sub = (ConceptImpl)subenumeration.nextConcept();
            sub.transitiveClosure();
            this._subsumes.includeElements((Enumeration)sub._subsumes.elements());
        }
    }

    void recalcDirectIsa(UpdatableSet visited) throws TypeException {
        if (!visited.includes((Object)this)) {
            visited.include((Object)this);
            try {
                this._directSupers.join();
            }
            catch (UnificationFailure uff) {
                TypeException tex = new TypeException(this);
                throw tex;
            }
            this._directSubs.meet();
            this._extensional = this._newExtensional;
            if (this._extensional) {
                this._subsumedBy = new HashedSet();
                this._subsumedBy.include((Object)this);
            } else {
                this._subsumedBy = null;
            }
            this._approp = (OrderedTable)this._newApprop.duplicate();
            ConceptEnumeration subenumeration = this._directSubs.elements();
            while (subenumeration.hasMoreElements()) {
                ((ConceptImpl)subenumeration.nextElement()).recalcDirectIsa(visited);
            }
        }
    }

    void basicAddIsa(ConceptImpl superconcept) {
        this._directSupers.addConcept(superconcept);
        superconcept._directSubs.addConcept(this);
        LOGGER.debug((Object)("Adding " + String.valueOf(this) + " isa " + String.valueOf(superconcept)));
    }

    public void addIsa(ConceptImpl superconcept) throws CyclicHierarchyException, TypeException {
        if (superconcept.isa(this)) {
            throw new CyclicHierarchyException();
        }
        if (this.isa(superconcept)) {
            return;
        }
        this.basicAddIsa(superconcept);
        TypeSystem.instance().recalcDirectIsa();
    }

    public void addApprop(String feature, ParsedType type) {
        this.addApprop(new Name(feature), type);
    }

    public void addApprop(Name featureName, ParsedType type) {
        LOGGER.debug((Object)("Feature " + String.valueOf(featureName) + " defined in " + this.getName()));
        this._newApprop.putAt(featureName, type);
    }

    public void setApprops(OrderedTable approps) {
        this._newApprop = (OrderedTable)approps.duplicate();
    }

    void buildFeatureTypes(UpdatableSet visited) throws TypeException {
        if (!visited.includes((Object)this)) {
            visited.include((Object)this);
            LOGGER.debug((Object)("Converting feature types for concept " + this.toDetailedString()));
            CollectionEnumeration featenumeration = this._approp.keys();
            while (featenumeration.hasMoreElements()) {
                Name feature = (Name)featenumeration.nextElement();
                LOGGER.debug((Object)("Converting feature " + String.valueOf(feature)));
                ParsedType pt = (ParsedType)this._approp.at(feature);
                try {
                    pt.asType();
                }
                catch (UnificationFailure uff) {
                    throw new TypeException(this, feature);
                }
            }
            ConceptEnumeration subenumeration = this._directSubs.elements();
            while (subenumeration.hasMoreElements()) {
                ((ConceptImpl)subenumeration.nextElement()).buildFeatureTypes(visited);
            }
        }
    }

    @Override
    public boolean isa(Concept that) {
        if (that instanceof ConceptImpl) {
            return ((ConceptImpl)that)._subsumes.includes((Object)this);
        }
        return false;
    }

    public Iterator<Object> getPartitions() {
        return this._partitions.iterator();
    }

    @Override
    public boolean isNotA(Concept that) {
        if (this == that) {
            return false;
        }
        if (that instanceof ConceptImpl) {
            ConceptImpl thatCon = (ConceptImpl)that;
            if (this.intersects(this._partitions, thatCon._partitions)) {
                return true;
            }
            return this.superIsNotA(thatCon) || thatCon.superIsNotA(this);
        }
        return true;
    }

    private boolean intersects(Set<?> a, Set<?> b) {
        if (a.size() > b.size()) {
            return this.intersects(b, a);
        }
        Iterator<?> as = a.iterator();
        while (as.hasNext()) {
            if (!b.contains(as.next())) continue;
            return true;
        }
        return false;
    }

    private boolean superIsNotA(ConceptImpl that) {
        ConceptEnumeration superenumeration = this._directSupers.elements();
        while (superenumeration.hasMoreElements()) {
            Concept superCon = superenumeration.nextConcept();
            if (!superCon.isNotA(that)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConceptEnumeration extensionalSuperconcepts() {
        return new ConceptEnumeration(this._subsumedBy.elements());
    }

    public String toString() {
        return this._name.toString();
    }

    public String toDetailedString() {
        StringBuffer output = new StringBuffer(this._name);
        if (this._extensional) {
            output.append(" (extensional)");
        }
        if (this._approp == null) {
            LOGGER.warn((Object)("Approp is null in " + this._name + " (" + this.hashCode() + ") !!!"));
        } else {
            CollectionEnumeration appropenum = this._approp.keys();
            while (appropenum.hasMoreElements()) {
                Name featureName = (Name)appropenum.nextElement();
                Object appropTypeGuess = this._approp.at(featureName);
                if (appropTypeGuess instanceof Type) {
                    Type appropType = (Type)appropTypeGuess;
                    output.append("\n ").append(featureName.toString()).append(":").append(appropType.getName());
                    continue;
                }
                output.append("\n ").append(featureName.toString()).append(":").append(appropTypeGuess.toString());
            }
        }
        output.append("\nDirect Supers: ").append(this._directSupers.toString());
        output.append("\nDirect Subs: ").append(this._directSubs.toString());
        return output.toString();
    }
}

